import _pt from "prop-types";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { cloneDeep } from 'lodash';
import { VictoryLine } from 'victory';
import { ChartLine } from '../ChartLine';
import { getThresholdTheme } from '../ChartUtils';
/**
 * See https://github.com/DefinitelyTyped/DefinitelyTyped/blob/master/types/victory/index.d.ts
 */

export const ChartThreshold = (_ref) => {
  let {
    style = {},
    themeColor,
    themeVariant,
    // destructure last
    theme = getThresholdTheme(themeColor, themeVariant)
  } = _ref,
      rest = _objectWithoutProperties(_ref, ["style", "themeColor", "themeVariant", "theme"]);

  // Returned style prop takes precedence over default theme
  const getStrokeDasharray = () => {
    if (style && style.data && style.data.strokeDasharray) {
      return style.data.strokeDasharray;
    }

    return getThresholdTheme(themeColor, themeVariant).line.style.data.strokeDasharray;
  };

  const getStrokeWidth = () => {
    if (style && style.data && style.data.strokeWidth) {
      return style.data.strokeWidth;
    }

    return getThresholdTheme(themeColor, themeVariant).line.style.data.strokeWidth;
  }; // Clone style and apply strokeDasharray prop


  const thresholdStyle = cloneDeep(style);

  if (thresholdStyle.data) {
    thresholdStyle.data.strokeDasharray = getStrokeDasharray();
    thresholdStyle.data.strokeWidth = getStrokeWidth();
  } else {
    thresholdStyle.data = {
      strokeDasharray: getStrokeDasharray(),
      strokeWidth: getStrokeWidth()
    };
  }

  return React.createElement(ChartLine, _extends({
    style: thresholdStyle,
    theme: theme
  }, rest));
}; // Note: VictoryLine.role must be hoisted

ChartThreshold.propTypes = {
  animate: _pt.any,
  categories: _pt.any,
  containerComponent: _pt.element,
  data: _pt.arrayOf(_pt.any),
  dataComponent: _pt.element,
  domain: _pt.any,
  domainPadding: _pt.any,
  eventKey: _pt.any,
  events: _pt.arrayOf(_pt.any),
  externalEventMutations: _pt.arrayOf(_pt.any),
  groupComponent: _pt.element,
  height: _pt.number,
  horizontal: _pt.bool,
  interpolation: _pt.any,
  labelComponent: _pt.element,
  labels: _pt.oneOfType([_pt.any, _pt.arrayOf(_pt.string), _pt.arrayOf(_pt.number)]),
  maxDomain: _pt.oneOfType([_pt.number, _pt.shape({
    x: _pt.number,
    y: _pt.number
  })]),
  minDomain: _pt.oneOfType([_pt.number, _pt.shape({
    x: _pt.number,
    y: _pt.number
  })]),
  name: _pt.string,
  origin: _pt.shape({
    x: _pt.number.isRequired,
    y: _pt.number.isRequired
  }),
  padding: _pt.any,
  polar: _pt.bool,
  range: _pt.oneOfType([_pt.shape({})]),
  samples: _pt.number,
  scale: _pt.oneOfType([_pt.any, _pt.any, _pt.shape({
    x: _pt.oneOfType([_pt.any, _pt.any]),
    y: _pt.oneOfType([_pt.any, _pt.any])
  })])
};
hoistNonReactStatics(ChartThreshold, VictoryLine);
//# sourceMappingURL=ChartThreshold.js.map