(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "@patternfly/react-tokens/dist/js/chart_area_Opacity", "@patternfly/react-tokens/dist/js/chart_color_black_500"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("@patternfly/react-tokens/dist/js/chart_area_Opacity"), require("@patternfly/react-tokens/dist/js/chart_color_black_500"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.chart_area_Opacity, global.chart_color_black_500);
    global.undefined = mod.exports;
  }
})(this, function (exports, _chart_area_Opacity, _chart_color_black_) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.getInteractiveLegendItemStyles = exports.getInteractiveLegendEvents = undefined;

  var _chart_area_Opacity2 = _interopRequireDefault(_chart_area_Opacity);

  var _chart_color_black_2 = _interopRequireDefault(_chart_color_black_);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });
      keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};

      if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }

    return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }
  /* eslint-disable camelcase */


  // Returns child names for each series, except given ID index
  const getChildNames = ({
    chartNames,
    omitIndex
  }) => {
    const result = [];
    chartNames.map((chartName, index) => {
      if (index !== omitIndex) {
        if (Array.isArray(chartName)) {
          chartName.forEach(name => result.push(name));
        } else {
          result.push(chartName);
        }
      }
    });
    return result;
  }; // Returns events for an interactive legend


  const getInteractiveLegendEvents = exports.getInteractiveLegendEvents = props => [...getInteractiveLegendTargetEvents(_objectSpread({}, props, {
    target: 'data'
  })), ...getInteractiveLegendTargetEvents(_objectSpread({}, props, {
    target: 'labels'
  }))]; // Returns legend items, except given ID index


  const getInteractiveLegendItems = ({
    chartNames,
    omitIndex
  }) => {
    const result = [];
    chartNames.map((_, index) => {
      if (index !== omitIndex) {
        result.push(index);
      }
    });
    return result;
  }; // Returns styles for interactive legend items


  const getInteractiveLegendItemStyles = exports.getInteractiveLegendItemStyles = (hidden = false) => !hidden ? {} : {
    labels: {
      fill: _chart_color_black_2.default.value
    },
    symbol: {
      fill: _chart_color_black_2.default.value,
      type: 'eyeSlash'
    }
  }; // Returns targeted events for legend 'data' or 'labels'


  const getInteractiveLegendTargetEvents = ({
    chartNames,
    isHidden = () => false,
    legendName,
    onLegendClick = () => null,
    target
  }) => {
    if (chartNames === undefined || legendName === undefined) {
      // eslint-disable-next-line no-console
      console.error('getInteractiveLegendTargetEvents:', 'requires chartNames and legendName to be specified');
      return [];
    }

    return chartNames.map((_, index) => {
      // Get IDs to attach events to, except the IDs associated with this event.
      //
      // For example, if the current event key is 0, we need IDs associated with events 1 and 2. If the current event
      // key is 1, we need IDs associated with events 0 and 2. And so on...
      const childNames = getChildNames({
        chartNames,
        legendName,
        omitIndex: index
      });
      const legendItems = getInteractiveLegendItems({
        chartNames,
        legendName,
        omitIndex: index
      });
      return {
        childName: legendName,
        target,
        eventKey: index,
        eventHandlers: {
          onClick: () => [{
            // Hide each data series individually
            target: 'data',
            mutation: props => {
              onLegendClick(props);
              return null;
            }
          }],
          onMouseOver: () => isHidden(index) ? null : [{
            // Mute all data series, except the data associated with this event
            childName: childNames,
            target: 'data',
            eventKey: 'all',
            mutation: props => ({
              style: _objectSpread({}, props.style, {
                opacity: _chart_area_Opacity2.default.value
              })
            })
          }, {
            // Mute all legend item symbols, except the symbol associated with this event
            childName: 'legend',
            target: 'data',
            eventKey: legendItems,
            mutation: props => isHidden(props.index) ? null : {
              // Skip if hidden
              style: _objectSpread({}, props.style, {
                opacity: _chart_area_Opacity2.default.value
              })
            }
          }, {
            // Mute all legend item labels, except the label associated with this event
            childName: 'legend',
            target: 'labels',
            eventKey: legendItems,
            mutation: props => {
              const column = props.datum && props.datum.column ? props.datum.column : 0;
              return isHidden(column) ? null : {
                // Skip if hidden
                style: _objectSpread({}, props.style, {
                  opacity: _chart_area_Opacity2.default.value
                })
              };
            }
          }],
          onMouseOut: () => [{
            // Restore all data series associated with this event
            childName: childNames,
            target: 'data',
            eventKey: 'all',
            mutation: () => null
          }, {
            // Restore all legend item symbols associated with this event
            childName: 'legend',
            target: 'data',
            eventKey: legendItems,
            mutation: () => null
          }, {
            // Restore all legend item labels associated with this event
            childName: 'legend',
            target: 'labels',
            eventKey: legendItems,
            mutation: () => null
          }]
        }
      };
    });
  };
});
//# sourceMappingURL=chart-interactive-legend.js.map