"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.actions = exports.editableRows = exports.editableColumns = exports.rows = exports.columns = void 0;

var React = _interopRequireWildcard(require("react"));

var _Table = require("../components/Table");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/* eslint-disable no-console */
var columns = [{
  title: 'Header cell'
}, 'Branches', {
  title: 'Pull requests'
}, 'Workspaces', {
  title: 'Last Commit'
}];
exports.columns = columns;
var rows = [{
  cells: ['one', 'two', 'three', 'four', 'five']
}, {
  cells: ['one', 'two', 'three', 'four', 'five']
}, {
  cells: ['one', 'two', 'three', 'four', 'five']
}, {
  cells: ['one', 'two', 'three', 'four', 'five']
}, {
  cells: ['one', 'two', 'three', 'four', 'five']
}, {
  cells: ['one', 'two', 'three', 'four', 'five']
}, {
  cells: ['one', 'two', 'three', 'four', 'five']
}, {
  cells: ['one', 'two', 'three', 'four', 'five']
}, {
  cells: ['one', 'two', 'three', 'four', 'five']
}];
exports.rows = rows;
var editableColumns = ['Text input col 1', 'Disabled text input col 2', 'Text input col 3', 'Text input col 4'];
exports.editableColumns = editableColumns;
var editableRows = [{
  isEditable: true,
  cells: [{
    title: function title(value, rowIndex, cellIndex, props) {
      return React.createElement(_Table.EditableTextCell, {
        value: value,
        rowIndex: rowIndex,
        cellIndex: cellIndex,
        props: props,
        handleTextInputChange: function handleTextInputChange() {},
        inputAriaLabel: "Row 1 cell 1 content"
      });
    },
    props: {
      value: 'Row 1 cell 1 content',
      name: 'uniqueIdRow1Cell1'
    }
  }, {
    title: function title(value, rowIndex, cellIndex, props) {
      return React.createElement(_Table.EditableTextCell, {
        value: value,
        rowIndex: rowIndex,
        cellIndex: cellIndex,
        props: props,
        isDisabled: true,
        handleTextInputChange: function handleTextInputChange() {},
        inputAriaLabel: "Row 1 cell 2 content"
      });
    },
    props: {
      value: 'Row 1 cell 2, disabled content',
      name: 'uniqueIdRow1Cell2'
    }
  }, {
    title: function title(value, rowIndex, cellIndex, props) {
      return React.createElement(_Table.EditableTextCell, {
        value: value,
        rowIndex: rowIndex,
        cellIndex: cellIndex,
        props: props,
        handleTextInputChange: function handleTextInputChange() {},
        inputAriaLabel: "Row 1 cell 3 content"
      });
    },
    props: {
      value: 'Row 1 cell 3 content',
      name: 'uniqueIdRow1Cell3'
    }
  }, {
    title: function title(value, rowIndex, cellIndex, props) {
      return React.createElement(_Table.EditableTextCell, {
        value: value,
        rowIndex: rowIndex,
        cellIndex: cellIndex,
        props: props,
        handleTextInputChange: function handleTextInputChange() {},
        inputAriaLabel: "Row 1 cell 4 content"
      });
    },
    props: {
      value: 'Row 1 cell 4 content',
      name: 'uniqueIdRow1Cell4'
    }
  }]
}, {
  isEditable: false,
  cells: [{
    title: function title(value, rowIndex, cellIndex, props) {
      return React.createElement(_Table.EditableTextCell, {
        value: value,
        rowIndex: rowIndex,
        cellIndex: cellIndex,
        props: props,
        handleTextInputChange: function handleTextInputChange() {},
        inputAriaLabel: "Row 1 cell 1 content"
      });
    },
    props: {
      value: 'Row 2 cell 1 content',
      name: 'uniqueIdRow2Cell1'
    }
  }, {
    title: function title(value, rowIndex, cellIndex, props) {
      return React.createElement(_Table.EditableTextCell, {
        value: value,
        rowIndex: rowIndex,
        cellIndex: cellIndex,
        props: props,
        isDisabled: true,
        handleTextInputChange: function handleTextInputChange() {},
        inputAriaLabel: "Row 2 cell 2 content"
      });
    },
    props: {
      value: 'Row 2 cell 2, disabled content',
      name: 'uniqueIdRow2Cell2'
    }
  }, {
    title: function title(value, rowIndex, cellIndex, props) {
      return React.createElement(_Table.EditableTextCell, {
        value: value,
        rowIndex: rowIndex,
        cellIndex: cellIndex,
        props: props,
        handleTextInputChange: function handleTextInputChange() {},
        inputAriaLabel: "Row 2 cell 3 content"
      });
    },
    props: {
      value: 'Row 2 cell 3 content',
      name: 'uniqueIdRow2Cell3'
    }
  }, {
    title: function title(value, rowIndex, cellIndex, props) {
      return React.createElement(_Table.EditableTextCell, {
        value: value,
        rowIndex: rowIndex,
        cellIndex: cellIndex,
        props: props,
        handleTextInputChange: function handleTextInputChange() {},
        inputAriaLabel: "Row 2 cell 4 content"
      });
    },
    props: {
      value: 'Row 2 cell 4 content',
      name: 'uniqueIdRow2Cell4'
    }
  }]
}];
exports.editableRows = editableRows;
var actions = [{
  title: 'Some action',
  onClick: function onClick(event, rowId) {
    return (// tslint:disable-next-line:no-console
      console.log('clicked on Some action, on row: ', rowId)
    );
  }
}, {
  title: React.createElement("div", null, "Another action"),
  onClick: function onClick(event, rowId) {
    return (// tslint:disable-next-line:no-console
      console.log('clicked on Another action, on row: ', rowId)
    );
  }
}, {
  isSeparator: true,
  onClick: null
}, {
  title: 'Third action',
  onClick: function onClick(event, rowId) {
    return (// tslint:disable-next-line:no-console
      console.log('clicked on Third action, on row: ', rowId)
    );
  }
}];
exports.actions = actions;
//# sourceMappingURL=data-sets.js.map