(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "@patternfly/react-core/dist/js/components/Dropdown/Dropdown", "@patternfly/react-core/dist/js/components/Dropdown/dropdownConstants", "@patternfly/react-core/dist/js/components/Dropdown/KebabToggle", "@patternfly/react-core/dist/js/components/Dropdown/DropdownItem", "@patternfly/react-core/dist/js/components/Dropdown/DropdownSeparator"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("@patternfly/react-core/dist/js/components/Dropdown/Dropdown"), require("@patternfly/react-core/dist/js/components/Dropdown/dropdownConstants"), require("@patternfly/react-core/dist/js/components/Dropdown/KebabToggle"), require("@patternfly/react-core/dist/js/components/Dropdown/DropdownItem"), require("@patternfly/react-core/dist/js/components/Dropdown/DropdownSeparator"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.Dropdown, global.dropdownConstants, global.KebabToggle, global.DropdownItem, global.DropdownSeparator);
    global.undefined = mod.exports;
  }
})(this, function (exports, _propTypes, _react, _Dropdown, _dropdownConstants, _KebabToggle, _DropdownItem, _DropdownSeparator) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ActionsColumn = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;
    var cache = new WeakMap();

    _getRequireWildcardCache = function () {
      return cache;
    };

    return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }

    var cache = _getRequireWildcardCache();

    if (cache && cache.has(obj)) {
      return cache.get(obj);
    }

    var newObj = {};

    if (obj != null) {
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;

      for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;

          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
    }

    newObj.default = obj;

    if (cache) {
      cache.set(obj, newObj);
    }

    return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  class ActionsColumn extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty(this, "onToggle", isOpen => {
        this.setState({
          isOpen
        });
      });

      _defineProperty(this, "onSelect", (event, onClick) => {
        const {
          rowData,
          extraData
        } = this.props; // Only prevent default if onClick is provided.  This allows href support.

        if (onClick) {
          event.preventDefault(); // tslint:disable-next-line:no-unused-expression

          onClick(event, extraData && extraData.rowIndex, rowData, extraData);
        }

        this.setState(prevState => ({
          isOpen: !prevState.isOpen
        }));
      });

      this.state = {
        isOpen: false
      };
    }

    render() {
      const {
        isOpen
      } = this.state;
      const {
        items,
        children,
        dropdownPosition,
        dropdownDirection,
        isDisabled
      } = this.props;
      return React.createElement(React.Fragment, null, React.createElement(_Dropdown.Dropdown, {
        toggle: React.createElement(_KebabToggle.KebabToggle, {
          isDisabled: isDisabled,
          onToggle: this.onToggle
        }),
        position: dropdownPosition,
        direction: dropdownDirection,
        isOpen: isOpen,
        dropdownItems: items.map((_ref, key) => {
          let {
            title,
            itemKey,
            onClick,
            isSeparator
          } = _ref,
              props = _objectWithoutProperties(_ref, ["title", "itemKey", "onClick", "isSeparator"]);

          return isSeparator ? React.createElement(_DropdownSeparator.DropdownSeparator, _extends({}, props, {
            key: itemKey || key,
            "data-key": itemKey || key
          })) : React.createElement(_DropdownItem.DropdownItem, _extends({
            component: "div",
            onClick: event => this.onSelect(event, onClick)
          }, props, {
            key: itemKey || key,
            "data-key": itemKey || key
          }), title);
        }),
        isPlain: true
      }), children);
    }

  }

  exports.ActionsColumn = ActionsColumn;

  _defineProperty(ActionsColumn, "propTypes", {
    children: _propTypes2.default.node,
    items: _propTypes2.default.arrayOf(_propTypes2.default.any),
    isDisabled: _propTypes2.default.bool,
    dropdownPosition: _propTypes2.default.any,
    dropdownDirection: _propTypes2.default.any,
    rowData: _propTypes2.default.any,
    extraData: _propTypes2.default.any
  });

  _defineProperty(ActionsColumn, "defaultProps", {
    children: null,
    items: [],
    dropdownPosition: _dropdownConstants.DropdownPosition.right,
    dropdownDirection: _dropdownConstants.DropdownDirection.down,
    rowData: {},
    extraData: {}
  });
});
//# sourceMappingURL=ActionsColumn.js.map