(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports);
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports);
    global.undefined = mod.exports;
  }
})(this, function (exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  const hasCompoundParentsExpanded = (parentId, compoundParent, rows) => {
    // max rows.length parents
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    for (const i of rows) {
      if (rows[parentId].hasOwnProperty('parent')) {
        parentId = rows[parentId].parent;
      } else {
        return rows[parentId].cells[compoundParent].props.isOpen;
      }
    }

    return false;
  };

  const hasParentsExpanded = (parentId, rows) => {
    // max rows.length parents
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    for (const i of rows) {
      if (rows[parentId].hasOwnProperty('parent')) {
        parentId = rows[parentId].parent;
      } else {
        return rows[parentId].isOpen;
      }
    }

    return false;
  };

  const isRowExpanded = exports.isRowExpanded = (row, rows) => {
    if (row.parent !== undefined) {
      if (row.hasOwnProperty('compoundParent')) {
        return hasCompoundParentsExpanded(row.parent, row.compoundParent, rows);
      }

      return hasParentsExpanded(row.parent, rows) && rows[row.parent].isOpen;
    }

    return undefined;
  };

  const getErrorTextByValidator = exports.getErrorTextByValidator = (validatorName, validators) => {
    const result = validators.filter(validator => validator.name === validatorName);
    return result[0].errorText;
  };

  const cancelCellEdits = exports.cancelCellEdits = row => {
    row.cells.forEach(cell => {
      delete cell.props.errorText;
      delete cell.props.editableValue;
      cell.props.isValid = true;
    });
    row.isEditable = !row.isEditable;
    row.isValid = true;
    return row;
  };

  const validateCellEdits = exports.validateCellEdits = (row, type, validationErrors, missingPropErrorTxt = 'Validation requires unique name property for row cells') => {
    row.isValid = Object.keys(validationErrors).length ? false : true;
    row.cells.forEach(cell => {
      delete cell.props.errorText;
      const hasValue = cell.props.value !== undefined && cell.props.value !== null;
      const hasEditableValue = cell.props.editableValue !== undefined && cell.props.editableValue !== null;

      if (cell.props && hasValue && hasEditableValue) {
        if (type === 'save') {
          const errorMsg = Object.keys(validationErrors).filter(validatorName => validationErrors[validatorName].includes(cell.props.name)).map(validatorName => getErrorTextByValidator(validatorName, row.rowEditValidationRules));

          if (errorMsg.length) {
            cell.props.errorText = cell.props.name ? errorMsg.join(', ') : missingPropErrorTxt;

            if (cell.props.name === undefined) {
              // eslint-disable-next-line no-console
              console.warn('Row edit validation reporting requires cell definitions to have a unique name property.');
            }
          } else {
            delete cell.props.errorText;
            cell.props.isValid = true;
          }
        }
      }
    });
    return row;
  };

  const applyCellEdits = exports.applyCellEdits = (row, type) => {
    row.cells.forEach(cell => {
      delete cell.props.errorText;
      const hasValue = cell.props.value !== undefined && cell.props.value !== null;
      const hasEditableValue = cell.props.editableValue !== undefined && cell.props.editableValue !== null;

      if (cell.props && hasValue && hasEditableValue) {
        if (type === 'save') {
          cell.props.value = cell.props.editableValue;
          cell.props.isValid = true;
          delete cell.props.errorText;
        }

        delete cell.props.editableValue;
      }
    });
    row.isEditable = !row.isEditable;
    row.isValid = true;
    return row;
  };
});
//# sourceMappingURL=utils.js.map