import { Knob } from './type-defs';
declare type Callback = () => any;
export declare type KnobStoreKnob = Knob & {
    name: string;
    label: string;
    used?: boolean;
    defaultValue?: any;
    hideLabel?: boolean;
    callback?: () => any;
};
export default class KnobStore {
    store: Record<string, KnobStoreKnob>;
    callbacks: Callback[];
    timer: number | undefined;
    has(key: string): boolean;
    set(key: string, value: KnobStoreKnob): void;
    update(key: string, options: Partial<KnobStoreKnob>): void;
    get(key: string): (Pick<import("./components/types").ObjectTypeKnob<any>, "value"> & {
        type: any;
        groupId?: string | undefined;
    } & {
        name: string;
        label: string;
        used?: boolean | undefined;
        defaultValue?: any;
        hideLabel?: boolean | undefined;
        callback?: (() => any) | undefined;
    }) | ({
        value?: undefined;
        callback: import("./components/types").ButtonTypeOnClickProp;
        hideLabel: true;
    } & {
        type: any;
        groupId?: string | undefined;
    } & {
        name: string;
        label: string;
        used?: boolean | undefined;
        defaultValue?: any;
        hideLabel?: boolean | undefined;
        callback?: (() => any) | undefined;
    });
    getAll(): Record<string, KnobStoreKnob>;
    reset(): void;
    markAllUnused(): void;
    subscribe(cb: Callback): void;
    unsubscribe(cb: Callback): void;
}
export {};
