exports.__esModule = true;
exports.createClient = createClient;
exports.mockObservableLink = mockObservableLink;
exports.mockSingleLink = mockSingleLink;
exports.stripSymbols = stripSymbols;
exports.wait = wait;
exports.MockedProvider = exports.MockSubscriptionLink = exports.MockLink = void 0;

var _tslib = require("tslib");

var _react = _interopRequireDefault(require("react"));

var _apolloClient = require("apollo-client");

var _apolloCacheInmemory = require("apollo-cache-inmemory");

var _reactCommon = require("@apollo/react-common");

var _apolloLink = require("apollo-link");

var _apolloUtilities = require("apollo-utilities");

var _printer = require("graphql/language/printer");

var _fastJsonStableStringify = _interopRequireDefault(require("fast-json-stable-stringify"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function requestToKey(request, addTypename) {
  var queryString = request.query && (0, _printer.print)(addTypename ? (0, _apolloUtilities.addTypenameToDocument)(request.query) : request.query);
  var requestKey = {
    query: queryString
  };
  return JSON.stringify(requestKey);
}

var MockLink = function (_super) {
  (0, _tslib.__extends)(MockLink, _super);

  function MockLink(mockedResponses, addTypename) {
    if (addTypename === void 0) {
      addTypename = true;
    }

    var _this = _super.call(this) || this;

    _this.addTypename = true;
    _this.mockedResponsesByKey = {};
    _this.addTypename = addTypename;
    if (mockedResponses) mockedResponses.forEach(function (mockedResponse) {
      _this.addMockedResponse(mockedResponse);
    });
    return _this;
  }

  MockLink.prototype.addMockedResponse = function (mockedResponse) {
    var normalizedMockedResponse = this.normalizeMockedResponse(mockedResponse);
    var key = requestToKey(normalizedMockedResponse.request, this.addTypename);
    var mockedResponses = this.mockedResponsesByKey[key];

    if (!mockedResponses) {
      mockedResponses = [];
      this.mockedResponsesByKey[key] = mockedResponses;
    }

    mockedResponses.push(normalizedMockedResponse);
  };

  MockLink.prototype.request = function (operation) {
    var key = requestToKey(operation, this.addTypename);
    var responseIndex;
    var response = (this.mockedResponsesByKey[key] || []).find(function (res, index) {
      var requestVariables = operation.variables || {};
      var mockedResponseVariables = res.request.variables || {};

      if (!(0, _apolloUtilities.isEqual)((0, _fastJsonStableStringify.default)(requestVariables), (0, _fastJsonStableStringify.default)(mockedResponseVariables))) {
        return false;
      }

      responseIndex = index;
      return true;
    });

    if (!response || typeof responseIndex === 'undefined') {
      throw new Error("No more mocked responses for the query: " + (0, _printer.print)(operation.query) + ", variables: " + JSON.stringify(operation.variables));
    }

    this.mockedResponsesByKey[key].splice(responseIndex, 1);
    var newData = response.newData;

    if (newData) {
      response.result = newData();
      this.mockedResponsesByKey[key].push(response);
    }

    var result = response.result,
        error = response.error,
        delay = response.delay;

    if (!result && !error) {
      throw new Error("Mocked response should contain either result or error: " + key);
    }

    return new _apolloLink.Observable(function (observer) {
      var timer = setTimeout(function () {
        if (error) {
          observer.error(error);
        } else {
          if (result) {
            observer.next(typeof result === 'function' ? result() : result);
          }

          observer.complete();
        }
      }, delay ? delay : 0);
      return function () {
        clearTimeout(timer);
      };
    });
  };

  MockLink.prototype.normalizeMockedResponse = function (mockedResponse) {
    var newMockedResponse = (0, _apolloUtilities.cloneDeep)(mockedResponse);
    newMockedResponse.request.query = (0, _apolloUtilities.removeConnectionDirectiveFromDocument)(newMockedResponse.request.query);
    var query = (0, _apolloUtilities.removeClientSetsFromDocument)(newMockedResponse.request.query);

    if (query) {
      newMockedResponse.request.query = query;
    }

    return newMockedResponse;
  };

  return MockLink;
}(_apolloLink.ApolloLink);

exports.MockLink = MockLink;

function mockSingleLink() {
  var mockedResponses = [];

  for (var _i = 0; _i < arguments.length; _i++) {
    mockedResponses[_i] = arguments[_i];
  }

  var maybeTypename = mockedResponses[mockedResponses.length - 1];
  var mocks = mockedResponses.slice(0, mockedResponses.length - 1);

  if (typeof maybeTypename !== 'boolean') {
    mocks = mockedResponses;
    maybeTypename = true;
  }

  return new MockLink(mocks, maybeTypename);
}

var MockedProvider = function (_super) {
  (0, _tslib.__extends)(MockedProvider, _super);

  function MockedProvider(props) {
    var _this = _super.call(this, props) || this;

    var _a = _this.props,
        mocks = _a.mocks,
        addTypename = _a.addTypename,
        defaultOptions = _a.defaultOptions,
        cache = _a.cache,
        resolvers = _a.resolvers,
        link = _a.link;
    var client = new _apolloClient.ApolloClient({
      cache: cache || new _apolloCacheInmemory.InMemoryCache({
        addTypename: addTypename
      }),
      defaultOptions: defaultOptions,
      link: link || new MockLink(mocks || [], addTypename),
      resolvers: resolvers
    });
    _this.state = {
      client: client
    };
    return _this;
  }

  MockedProvider.prototype.render = function () {
    var _a = this.props,
        children = _a.children,
        childProps = _a.childProps;
    return children ? _react.default.createElement(_reactCommon.ApolloProvider, {
      client: this.state.client
    }, _react.default.cloneElement(_react.default.Children.only(children), (0, _tslib.__assign)({}, childProps))) : null;
  };

  MockedProvider.prototype.componentWillUnmount = function () {
    this.state.client.stop();
  };

  MockedProvider.defaultProps = {
    addTypename: true
  };
  return MockedProvider;
}(_react.default.Component);

exports.MockedProvider = MockedProvider;

var MockSubscriptionLink = function (_super) {
  (0, _tslib.__extends)(MockSubscriptionLink, _super);

  function MockSubscriptionLink() {
    var _this = _super.call(this) || this;

    _this.unsubscribers = [];
    _this.setups = [];
    return _this;
  }

  MockSubscriptionLink.prototype.request = function (_req) {
    var _this = this;

    return new _apolloLink.Observable(function (observer) {
      _this.setups.forEach(function (x) {
        return x();
      });

      _this.observer = observer;
      return function () {
        _this.unsubscribers.forEach(function (x) {
          return x();
        });
      };
    });
  };

  MockSubscriptionLink.prototype.simulateResult = function (result, complete) {
    var _this = this;

    if (complete === void 0) {
      complete = false;
    }

    setTimeout(function () {
      var observer = _this.observer;
      if (!observer) throw new Error('subscription torn down');
      if (complete && observer.complete) observer.complete();
      if (result.result && observer.next) observer.next(result.result);
      if (result.error && observer.error) observer.error(result.error);
    }, result.delay || 0);
  };

  MockSubscriptionLink.prototype.onSetup = function (listener) {
    this.setups = this.setups.concat([listener]);
  };

  MockSubscriptionLink.prototype.onUnsubscribe = function (listener) {
    this.unsubscribers = this.unsubscribers.concat([listener]);
  };

  return MockSubscriptionLink;
}(_apolloLink.ApolloLink);

exports.MockSubscriptionLink = MockSubscriptionLink;

function mockObservableLink() {
  return new MockSubscriptionLink();
}

function createClient(data, query, variables) {
  if (variables === void 0) {
    variables = {};
  }

  return new _apolloClient.ApolloClient({
    link: mockSingleLink({
      request: {
        query: query,
        variables: variables
      },
      result: {
        data: data
      }
    }),
    cache: new _apolloCacheInmemory.InMemoryCache({
      addTypename: false
    })
  });
}

function stripSymbols(data) {
  return JSON.parse(JSON.stringify(data));
}

function wait(ms) {
  return new Promise(function (resolve) {
    return setTimeout(resolve, ms);
  });
}
