"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInteractiveLegendItemStyles = exports.getInteractiveLegendEvents = void 0;

var _chart_area_Opacity = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_area_Opacity"));

var _chart_color_black_ = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_color_black_500"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

// Returns child names for each series, except given ID index
var getChildNames = function getChildNames(_ref) {
  var chartNames = _ref.chartNames,
      omitIndex = _ref.omitIndex;
  var result = [];
  chartNames.map(function (chartName, index) {
    if (index !== omitIndex) {
      if (Array.isArray(chartName)) {
        chartName.forEach(function (name) {
          return result.push(name);
        });
      } else {
        result.push(chartName);
      }
    }
  });
  return result;
}; // Returns events for an interactive legend


var getInteractiveLegendEvents = function getInteractiveLegendEvents(props) {
  return [].concat(_toConsumableArray(getInteractiveLegendTargetEvents(_objectSpread({}, props, {
    target: 'data'
  }))), _toConsumableArray(getInteractiveLegendTargetEvents(_objectSpread({}, props, {
    target: 'labels'
  }))));
}; // Returns legend items, except given ID index


exports.getInteractiveLegendEvents = getInteractiveLegendEvents;

var getInteractiveLegendItems = function getInteractiveLegendItems(_ref2) {
  var chartNames = _ref2.chartNames,
      omitIndex = _ref2.omitIndex;
  var result = [];
  chartNames.map(function (_, index) {
    if (index !== omitIndex) {
      result.push(index);
    }
  });
  return result;
}; // Returns styles for interactive legend items


var getInteractiveLegendItemStyles = function getInteractiveLegendItemStyles() {
  var hidden = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
  return !hidden ? {} : {
    labels: {
      fill: _chart_color_black_["default"].value
    },
    symbol: {
      fill: _chart_color_black_["default"].value,
      type: 'eyeSlash'
    }
  };
}; // Returns targeted events for legend 'data' or 'labels'


exports.getInteractiveLegendItemStyles = getInteractiveLegendItemStyles;

var getInteractiveLegendTargetEvents = function getInteractiveLegendTargetEvents(_ref3) {
  var chartNames = _ref3.chartNames,
      _ref3$isHidden = _ref3.isHidden,
      isHidden = _ref3$isHidden === void 0 ? function () {
    return false;
  } : _ref3$isHidden,
      legendName = _ref3.legendName,
      _ref3$onLegendClick = _ref3.onLegendClick,
      onLegendClick = _ref3$onLegendClick === void 0 ? function () {
    return null;
  } : _ref3$onLegendClick,
      target = _ref3.target;

  if (chartNames === undefined || legendName === undefined) {
    // eslint-disable-next-line no-console
    console.error('getInteractiveLegendTargetEvents:', 'requires chartNames and legendName to be specified');
    return [];
  }

  return chartNames.map(function (_, index) {
    // Get IDs to attach events to, except the IDs associated with this event.
    //
    // For example, if the current event key is 0, we need IDs associated with events 1 and 2. If the current event
    // key is 1, we need IDs associated with events 0 and 2. And so on...
    var childNames = getChildNames({
      chartNames: chartNames,
      legendName: legendName,
      omitIndex: index
    });
    var legendItems = getInteractiveLegendItems({
      chartNames: chartNames,
      legendName: legendName,
      omitIndex: index
    });
    return {
      childName: legendName,
      target: target,
      eventKey: index,
      eventHandlers: {
        onClick: function onClick() {
          return [{
            // Hide each data series individually
            target: 'data',
            mutation: function mutation(props) {
              onLegendClick(props);
              return null;
            }
          }];
        },
        onMouseOver: function onMouseOver() {
          return isHidden(index) ? null : [{
            // Mute all data series, except the data associated with this event
            childName: childNames,
            target: 'data',
            eventKey: 'all',
            mutation: function mutation(props) {
              return {
                style: _objectSpread({}, props.style, {
                  opacity: _chart_area_Opacity["default"].value
                })
              };
            }
          }, {
            // Mute all legend item symbols, except the symbol associated with this event
            childName: 'legend',
            target: 'data',
            eventKey: legendItems,
            mutation: function mutation(props) {
              return isHidden(props.index) ? null : {
                // Skip if hidden
                style: _objectSpread({}, props.style, {
                  opacity: _chart_area_Opacity["default"].value
                })
              };
            }
          }, {
            // Mute all legend item labels, except the label associated with this event
            childName: 'legend',
            target: 'labels',
            eventKey: legendItems,
            mutation: function mutation(props) {
              var column = props.datum && props.datum.column ? props.datum.column : 0;
              return isHidden(column) ? null : {
                // Skip if hidden
                style: _objectSpread({}, props.style, {
                  opacity: _chart_area_Opacity["default"].value
                })
              };
            }
          }];
        },
        onMouseOut: function onMouseOut() {
          return [{
            // Restore all data series associated with this event
            childName: childNames,
            target: 'data',
            eventKey: 'all',
            mutation: function mutation() {
              return null;
            }
          }, {
            // Restore all legend item symbols associated with this event
            childName: 'legend',
            target: 'data',
            eventKey: legendItems,
            mutation: function mutation() {
              return null;
            }
          }, {
            // Restore all legend item labels associated with this event
            childName: 'legend',
            target: 'labels',
            eventKey: legendItems,
            mutation: function mutation() {
              return null;
            }
          }];
        }
      }
    };
  });
};
//# sourceMappingURL=chart-interactive-legend.js.map