(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "@patternfly/react-core", "@patternfly/react-styles/css/components/InlineEdit/inline-edit", "@patternfly/react-styles/css/components/Form/form", "classnames"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("@patternfly/react-core"), require("@patternfly/react-styles/css/components/InlineEdit/inline-edit"), require("@patternfly/react-styles/css/components/Form/form"), require("classnames"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.reactCore, global.inlineEdit, global.form, global.classnames);
    global.undefined = mod.exports;
  }
})(this, function (exports, _propTypes, _react, _reactCore, _inlineEdit, _form, _classnames) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.EditableTextCell = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var _inlineEdit2 = _interopRequireDefault(_inlineEdit);

  var _form2 = _interopRequireDefault(_form);

  var _classnames2 = _interopRequireDefault(_classnames);

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;
    var cache = new WeakMap();

    _getRequireWildcardCache = function () {
      return cache;
    };

    return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }

    var cache = _getRequireWildcardCache();

    if (cache && cache.has(obj)) {
      return cache.get(obj);
    }

    var newObj = {};

    if (obj != null) {
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;

      for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;

          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
    }

    newObj.default = obj;

    if (cache) {
      cache.set(obj, newObj);
    }

    return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  // eslint-disable-next-line @typescript-eslint/interface-name-prefix
  const EditableTextCell = exports.EditableTextCell = ({
    value,
    rowIndex,
    cellIndex,
    props,
    handleTextInputChange,
    inputAriaLabel,
    isDisabled
  }) => React.createElement(React.Fragment, null, React.createElement("div", {
    className: _inlineEdit2.default.inlineEditValue
  }, value), React.createElement("div", {
    className: _inlineEdit2.default.inlineEditInput
  }, React.createElement(_reactCore.TextInput, {
    isDisabled: isDisabled,
    value: props.editableValue !== undefined ? props.editableValue : value,
    isValid: props.isValid,
    type: "text",
    onChange: (newValue, event) => {
      handleTextInputChange(newValue, event, rowIndex, cellIndex);
    },
    "aria-label": inputAriaLabel
  }), React.createElement("div", {
    className: (0, _classnames2.default)(_form2.default.formHelperText, _form2.default.modifiers.error),
    "aria-live": "polite"
  }, props.errorText)));

  EditableTextCell.propTypes = {
    value: _propTypes2.default.string.isRequired,
    rowIndex: _propTypes2.default.number.isRequired,
    cellIndex: _propTypes2.default.number.isRequired,
    props: _propTypes2.default.any.isRequired,
    handleTextInputChange: _propTypes2.default.func.isRequired,
    inputAriaLabel: _propTypes2.default.string.isRequired,
    isDisabled: _propTypes2.default.bool
  };
});
//# sourceMappingURL=EditableTextCell.js.map