/*
 * Copyright 2020, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

import * as React from "react";
import { Brand } from "@patternfly/react-core";
import { CrossNavHeader, CrossNavApp } from "@rh-uxd/integration-react";
import {
  getAvailableApps,
  getSolutionExplorerServer
} from "@rh-uxd/integration-core";
import rhmiImage from "@rh-uxd/integration-core/styles/assets/Logo-Red_Hat-Managed_Integration-A-Reverse-RGB.png";

interface NavProps {
  logo: React.ReactNode;
  logoProps: object;
  toolbar: React.ReactNode;
  avatar: React.ReactNode;
}

const AppCrossNavHeader: React.FC<NavProps> = ({
  logo,
  logoProps,
  toolbar,
  avatar
}) => {
  const rhmiImgLogo = <Brand src={rhmiImage} alt="Integration Logo" />;
  const [availableApps, setHasAvailableApps] = React.useState<
    CrossNavApp[] | null
  >(null);
  const [showLogo, setShowLog] = React.useState(false);

  if (!availableApps) {
    getAvailableApps(
      process.env.REACT_APP_RHMI_SERVER_URL
        ? process.env.REACT_APP_RHMI_SERVER_URL
        : getSolutionExplorerServer(),
      undefined,
      process.env.REACT_APP_RHMI_SERVER_URL ? "localhost:3006" : undefined,
      ["3scale", "amqonline"],
      !!process.env.REACT_APP_RHMI_SERVER_URL
    ).then(apps => {
      setHasAvailableApps(apps);
      setShowLog(true);
    });
  }

  return (
    <CrossNavHeader
      apps={availableApps}
      currentApp={{
        id: "amqonline",
        name: "AMQ Online",
        rootUrl: window.location.href
      }}
      logo={
        showLogo
          ? availableApps && availableApps.length > 0
            ? rhmiImgLogo
            : logo
          : null
      }
      className="App-cross-nav"
      logoProps={logoProps}
      avatar={avatar}
      toolbar={toolbar}
    />
  );
};

export default AppCrossNavHeader;
