/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.annotations;

import io.strimzi.systemtest.annotations.RequiredMinKubeApiVersion;
import io.strimzi.test.k8s.KubeClusterResource;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class RequiredMinKubeApiVersionCondition
implements ExecutionCondition {
    private static final Logger LOGGER = LogManager.getLogger(RequiredMinKubeApiVersionCondition.class);

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext extensionContext) {
        Optional annotation = AnnotationSupport.findAnnotation((Optional)extensionContext.getElement(), RequiredMinKubeApiVersion.class);
        KubeClusterResource clusterResource = KubeClusterResource.getInstance();
        double version = ((RequiredMinKubeApiVersion)annotation.get()).version();
        if (Double.parseDouble(clusterResource.client().clusterKubernetesVersion()) >= version) {
            return ConditionEvaluationResult.enabled((String)"Test is enabled");
        }
        LOGGER.info("{} is @RequiredMinKubeApiVersion with version {}, but the running on cluster with {}: Ignoring {}", (Object)extensionContext.getDisplayName(), (Object)version, (Object)clusterResource.client().clusterKubernetesVersion(), (Object)extensionContext.getDisplayName());
        return ConditionEvaluationResult.disabled((String)"Test is disabled");
    }
}

