/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.kafkaclients.externalClients;

import io.strimzi.systemtest.kafkaclients.clientproperties.ProducerProperties;
import io.strimzi.systemtest.kafkaclients.externalClients.ClientHandlerBase;
import io.vertx.core.Vertx;
import io.vertx.kafka.client.producer.KafkaProducer;
import io.vertx.kafka.client.producer.KafkaProducerRecord;
import io.vertx.kafka.client.producer.RecordMetadata;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntPredicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Producer
extends ClientHandlerBase<Integer>
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger(Producer.class);
    private ProducerProperties properties;
    private final AtomicInteger numSent = new AtomicInteger(0);
    private final String topic;
    private String clientName;
    private final Integer partition;
    private KafkaProducer<String, String> producer;

    Producer(ProducerProperties properties, CompletableFuture<Integer> resultPromise, IntPredicate msgCntPredicate, String topic, String clientName, Integer partition) {
        super(resultPromise, msgCntPredicate);
        this.properties = properties;
        this.partition = partition;
        this.topic = topic;
        this.clientName = clientName;
        this.vertx = Vertx.vertx();
        this.producer = KafkaProducer.create((Vertx)this.vertx, (Properties)properties.getProperties());
    }

    @Override
    protected void handleClient() {
        LOGGER.info("Creating instance of Vert.x for the client {}", (Object)this.getClass().getName());
        LOGGER.info("Producer is starting with following properties: {}", (Object)this.properties.getProperties().toString());
        if (this.msgCntPredicate.test(-1)) {
            this.vertx.eventBus().consumer(this.clientName, msg -> {
                if (msg.body().equals("stop")) {
                    LOGGER.debug("Received stop command! Produced messages: {}", (Object)this.numSent.get());
                    this.resultPromise.complete(this.numSent.get());
                }
            });
            this.vertx.setPeriodic(1000L, id -> this.sendNext(this.topic));
        } else {
            this.sendNext(this.topic);
        }
    }

    @Override
    public void close() {
        if (this.vertx != null) {
            if (this.producer != null) {
                LOGGER.info("Closing Producer instance {} with client.id {}", (Object)this.producer.getClass().getName(), this.properties.getProperties().get("client.id"));
                this.producer.close();
            }
            LOGGER.info("Closing Vert.x instance {}", (Object)this.getClass().getName());
            this.vertx.close();
        }
    }

    private void sendNext(String topic) {
        if (this.msgCntPredicate.negate().test(this.numSent.get())) {
            KafkaProducerRecord record = this.partition != null ? KafkaProducerRecord.create((String)topic, null, (Object)("\"Hello-world - " + this.numSent.get() + "\""), (Integer)this.partition) : KafkaProducerRecord.create((String)topic, (Object)("\"Hello-world - " + this.numSent.get() + "\""));
            this.producer.send(record, done -> {
                if (done.succeeded()) {
                    RecordMetadata recordMetadata = (RecordMetadata)done.result();
                    LOGGER.debug("Message " + (String)record.value() + " written on topic=" + recordMetadata.getTopic() + ", partition=" + recordMetadata.getPartition() + ", offset=" + recordMetadata.getOffset());
                    this.numSent.getAndIncrement();
                    if (this.msgCntPredicate.test(this.numSent.get())) {
                        LOGGER.info("Producer produced {} messages", (Object)this.numSent.get());
                        this.resultPromise.complete(this.numSent.get());
                    }
                    if (this.msgCntPredicate.negate().test(-1)) {
                        this.sendNext(topic);
                    }
                } else {
                    if (this.vertx == null || done.cause() instanceof IllegalStateException) {
                        return;
                    }
                    LOGGER.debug("Producer cannot connect to topic {}: {}", (Object)topic, (Object)done.cause().toString());
                    this.sendNext(topic);
                }
            });
        }
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }
}

