/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.security;

import io.strimzi.systemtest.security.CertAndKeyFiles;
import io.strimzi.systemtest.security.SystemTestCertAndKey;
import io.strimzi.systemtest.security.SystemTestCertAndKeyBuilder;
import io.strimzi.test.k8s.KubeClusterResource;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public class SystemTestCertManager {
    private static final String KAFKA_CERT_FILE_PATH = "/opt/kafka/broker-certs/";
    private static final String ZK_CERT_FILE_PATH = "/opt/kafka/zookeeper-node-certs/";
    private static final String CA_FILE_PATH = "/opt/kafka/cluster-ca-certs/ca.crt";
    static final String STRIMZI_ROOT_CA = "C=CZ, L=Prague, O=Strimzi, CN=StrimziRootCA";
    static final String STRIMZI_INTERMEDIATE_CA = "C=CZ, L=Prague, O=Strimzi, CN=StrimziIntermediateCA";
    static final String STRIMZI_END_SUBJECT = "C=CZ, L=Prague, O=Strimzi, CN=kafka.strimzi.io";

    private static List<String> generateBaseSSLCommand(String server, String caFilePath, String hostname) {
        return new ArrayList<String>(Arrays.asList("echo -n | openssl", "s_client", "-connect", server, "-showcerts", "-CAfile", caFilePath, "-verify_hostname", hostname));
    }

    public static String generateOpenSslCommandByComponent(String podName, String hostname, String port, String component, String namespace) {
        return SystemTestCertManager.generateOpenSslCommandByComponent(podName + "." + hostname + ":" + port, podName + "." + hostname + "." + namespace + ".svc.cluster.local", podName, component, true);
    }

    public static String generateOpenSslCommandByComponent(String server, String hostname, String podName, String component) {
        return SystemTestCertManager.generateOpenSslCommandByComponent(server, hostname, podName, component, true);
    }

    public static String generateOpenSslCommandByComponent(String server, String hostname, String podName, String component, boolean withCertAndKey) {
        String path = component.equals("kafka") ? KAFKA_CERT_FILE_PATH : ZK_CERT_FILE_PATH;
        List<String> cmd = SystemTestCertManager.generateBaseSSLCommand(server, CA_FILE_PATH, hostname);
        if (withCertAndKey) {
            cmd.add("-cert " + path + podName + ".crt");
            cmd.add("-key " + path + podName + ".key");
        }
        if (component.equals("kafka")) {
            return KubeClusterResource.cmdKubeClient().execInPod(podName, new String[]{"/bin/bash", "-c", String.join((CharSequence)" ", cmd)}).out();
        }
        return KubeClusterResource.cmdKubeClient().execInPod(podName, new String[]{"/bin/bash", "-c", String.join((CharSequence)" ", cmd)}).out();
    }

    public static List<String> getCertificateChain(String certificateName) {
        return new ArrayList<String>(Arrays.asList("s:/O=io.strimzi/CN=" + certificateName + "\n   i:/O=io.strimzi/CN=cluster-ca", "Server certificate\nsubject=/O=io.strimzi/CN=" + certificateName + "\nissuer=/O=io.strimzi/CN=cluster-ca"));
    }

    public static SystemTestCertAndKey generateRootCaCertAndKey() {
        return SystemTestCertAndKeyBuilder.rootCaCertBuilder().withIssuerDn(STRIMZI_ROOT_CA).withSubjectDn(STRIMZI_ROOT_CA).build();
    }

    public static SystemTestCertAndKey generateIntermediateCaCertAndKey(SystemTestCertAndKey rootCert) {
        return SystemTestCertAndKeyBuilder.intermediateCaCertBuilder(rootCert).withSubjectDn(STRIMZI_INTERMEDIATE_CA).build();
    }

    public static SystemTestCertAndKey generateStrimziCaCertAndKey(SystemTestCertAndKey rootCert, String subjectDn) {
        return SystemTestCertAndKeyBuilder.strimziCaCertBuilder(rootCert).withSubjectDn(subjectDn).build();
    }

    public static SystemTestCertAndKey generateEndEntityCertAndKey(SystemTestCertAndKey intermediateCert) {
        return SystemTestCertAndKeyBuilder.endEntityCertBuilder(intermediateCert).withSubjectDn(STRIMZI_END_SUBJECT).withSanDnsName("*.127.0.0.1.nip.io").build();
    }

    public static SystemTestCertAndKey generateEndEntityCertAndKey(SystemTestCertAndKey intermediateCert, String subjectDn) {
        return SystemTestCertAndKeyBuilder.endEntityCertBuilder(intermediateCert).withSubjectDn(subjectDn).withSanDnsName("*.127.0.0.1.nip.io").build();
    }

    public static CertAndKeyFiles exportToPemFiles(SystemTestCertAndKey ... certs) {
        if (certs.length == 0) {
            throw new IllegalArgumentException("List of certificates should has at least one element");
        }
        try {
            File keyFile = SystemTestCertManager.exportPrivateKeyToPemFile(certs[0].getPrivateKey());
            File certFile = SystemTestCertManager.exportCertsToPemFile(certs);
            return new CertAndKeyFiles(certFile, keyFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static File convertPrivateKeyToPKCS8File(PrivateKey privatekey) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        byte[] encoded = privatekey.getEncoded();
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)encoded);
        ASN1Encodable asn1Encodable = privateKeyInfo.parsePrivateKey();
        byte[] privateKeyPKCS8Formatted = asn1Encodable.toASN1Primitive().getEncoded("DER");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyPKCS8Formatted);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = kf.generatePrivate(keySpec);
        return SystemTestCertManager.exportPrivateKeyToPemFile(privateKey);
    }

    private static File exportPrivateKeyToPemFile(PrivateKey privateKey) throws IOException {
        File keyFile = File.createTempFile("key-", ".key");
        try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)new FileWriter(keyFile, StandardCharsets.UTF_8));){
            pemWriter.writeObject((Object)privateKey);
            pemWriter.flush();
        }
        return keyFile;
    }

    private static File exportCertsToPemFile(SystemTestCertAndKey ... certs) throws IOException {
        File certFile = File.createTempFile("crt-", ".crt");
        try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)new FileWriter(certFile, StandardCharsets.UTF_8));){
            for (SystemTestCertAndKey certAndKey : certs) {
                pemWriter.writeObject((Object)certAndKey.getCertificate());
            }
            pemWriter.flush();
        }
        return certFile;
    }

    static boolean containsAllDN(String principal1, String principal2) {
        try {
            return new LdapName(principal1).getRdns().containsAll(new LdapName(principal2).getRdns());
        }
        catch (InvalidNameException e) {
            e.printStackTrace();
            return false;
        }
    }
}

