/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.kubeUtils.objects;

import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.strimzi.api.kafka.model.storage.JbodStorage;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorage;
import io.strimzi.api.kafka.model.storage.SingleVolumeStorage;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.resources.ResourceOperation;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PersistentVolumeClaimUtils {
    private static final Logger LOGGER = LogManager.getLogger(PersistentVolumeClaimUtils.class);
    private static final long DELETION_TIMEOUT = ResourceOperation.getTimeoutForResourceDeletion();

    private PersistentVolumeClaimUtils() {
    }

    public static void waitUntilPVCLabelsChange(Map<String, String> newLabels, String labelKey) {
        LOGGER.info("Wait until PVC labels will change {}", (Object)newLabels.toString());
        TestUtils.waitFor((String)"PVC labels will change {}", (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_STATUS_TIMEOUT, () -> {
            for (PersistentVolumeClaim pvc : KubeClusterResource.kubeClient().listPersistentVolumeClaims()) {
                if (((String)pvc.getMetadata().getLabels().get(labelKey)).equals(newLabels.get(labelKey))) continue;
                return false;
            }
            return true;
        });
        LOGGER.info("PVC labels has changed {}", (Object)newLabels.toString());
    }

    public static void waitUntilPVCAnnotationChange(Map<String, String> newAnnotation, String annotationKey) {
        LOGGER.info("Wait until PVC annotation will change {}", (Object)newAnnotation.toString());
        TestUtils.waitFor((String)"PVC labels will change {}", (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_STATUS_TIMEOUT, () -> {
            for (PersistentVolumeClaim pvc : KubeClusterResource.kubeClient().listPersistentVolumeClaims()) {
                if (((String)pvc.getMetadata().getLabels().get(annotationKey)).equals(newAnnotation.get(annotationKey))) continue;
                return false;
            }
            return true;
        });
        LOGGER.info("PVC annotation has changed {}", (Object)newAnnotation.toString());
    }

    public static void waitUntilPVCDeletion(String clusterName) {
        LOGGER.info("Wait until PVC deletion for cluster {}", (Object)clusterName);
        TestUtils.waitFor((String)"PVC will be deleted {}", (long)Constants.GLOBAL_POLL_INTERVAL, (long)DELETION_TIMEOUT, () -> {
            List pvcList = KubeClusterResource.kubeClient().listPersistentVolumeClaims().stream().filter(pvc -> pvc.getMetadata().getName().contains(clusterName)).collect(Collectors.toList());
            if (pvcList.isEmpty()) {
                return true;
            }
            for (PersistentVolumeClaim pvc2 : pvcList) {
                LOGGER.warn("PVC {} is not deleted yet! Triggering force delete by cmd client!", (Object)pvc2.getMetadata().getName());
                KubeClusterResource.cmdKubeClient().deleteByName("pvc", pvc2.getMetadata().getName());
            }
            return false;
        });
        LOGGER.info("PVC for cluster {} was deleted", (Object)clusterName);
    }

    public static void waitForPVCDeletion(int kafkaReplicas, JbodStorage jbodStorage, String clusterName) {
        TestUtils.waitFor((String)"Wait for PVC deletion", (long)Constants.POLL_INTERVAL_FOR_RESOURCE_DELETION, (long)DELETION_TIMEOUT, () -> {
            List pvcs = KubeClusterResource.kubeClient().listPersistentVolumeClaims().stream().map(pvc -> pvc.getMetadata().getName()).collect(Collectors.toList());
            boolean isCorrect = false;
            for (SingleVolumeStorage singleVolumeStorage : jbodStorage.getVolumes()) {
                for (int i = 0; i < kafkaReplicas; ++i) {
                    String jbodPVCName = "data-" + singleVolumeStorage.getId() + "-" + clusterName + "-kafka-" + i;
                    boolean deleteClaim = ((PersistentClaimStorage)singleVolumeStorage).isDeleteClaim();
                    if (!(deleteClaim && !pvcs.contains(jbodPVCName) || !deleteClaim && pvcs.contains(jbodPVCName))) {
                        isCorrect = false;
                        break;
                    }
                    isCorrect = true;
                }
                if (isCorrect) continue;
                break;
            }
            return isCorrect;
        });
    }
}

