/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.specific;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.kafka.model.KafkaResources;
import io.strimzi.api.kafka.model.KafkaTopic;
import io.strimzi.operator.cluster.operator.resource.cruisecontrol.CruiseControlConfigurationParameters;
import io.strimzi.operator.cluster.operator.resource.cruisecontrol.CruiseControlEndpoints;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.resources.crd.KafkaTopicResource;
import io.strimzi.systemtest.utils.kubeUtils.objects.PodUtils;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CruiseControlUtils {
    private static final Logger LOGGER = LogManager.getLogger(CruiseControlUtils.class);
    public static final String CRUISE_CONTROL_METRICS_TOPIC = "strimzi.cruisecontrol.metrics";
    public static final String CRUISE_CONTROL_MODEL_TRAINING_SAMPLES_TOPIC = "strimzi.cruisecontrol.modeltrainingsamples";
    public static final String CRUISE_CONTROL_PARTITION_METRICS_SAMPLES_TOPIC = "strimzi.cruisecontrol.partitionmetricsamples";
    private static final int CRUISE_CONTROL_DEFAULT_PORT = 9090;
    private static final int CRUISE_CONTROL_METRICS_PORT = 9404;
    private static final String CONTAINER_NAME = "cruise-control";

    private CruiseControlUtils() {
    }

    @SuppressFBWarnings(value={"DM_CONVERT_CASE"})
    public static String callApi(SupportedHttpMethods method, CruiseControlEndpoints endpoint) {
        String ccPodName = PodUtils.getFirstPodNameContaining(CONTAINER_NAME);
        return KubeClusterResource.cmdKubeClient().execInPodContainer(false, ccPodName, CONTAINER_NAME, new String[]{"/bin/bash", "-c", "curl -X" + method.name() + " localhost:9090" + endpoint.toString()}).out();
    }

    @SuppressFBWarnings(value={"DM_CONVERT_CASE"})
    public static String callApi(SupportedHttpMethods method, String endpoint) {
        String ccPodName = PodUtils.getFirstPodNameContaining(CONTAINER_NAME);
        return KubeClusterResource.cmdKubeClient().execInPodContainer(false, ccPodName, CONTAINER_NAME, new String[]{"/bin/bash", "-c", "curl -X" + method.name() + " localhost:9404" + endpoint}).out();
    }

    public static void verifyCruiseControlMetricReporterConfigurationInKafkaConfigMapIsPresent(Properties kafkaProperties) {
        String kafkaClusterName = kafkaProperties.getProperty("cluster-name");
        TestUtils.waitFor((String)("Verify that kafka configuration " + kafkaProperties.toString() + " has correct cruise control metric reporter properties"), (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_CRUISE_CONTROL_TIMEOUT, () -> kafkaProperties.getProperty(CruiseControlConfigurationParameters.METRICS_TOPIC_NAME.getValue()).equals(CRUISE_CONTROL_METRICS_TOPIC) && kafkaProperties.getProperty(CruiseControlConfigurationParameters.METRICS_REPORTER_SSL_ENDPOINT_ID_ALGO.getValue()).equals("HTTPS") && kafkaProperties.getProperty(CruiseControlConfigurationParameters.METRICS_REPORTER_BOOTSTRAP_SERVERS.getValue()).equals(kafkaClusterName + "-kafka-brokers:9091") && kafkaProperties.getProperty(CruiseControlConfigurationParameters.METRICS_REPORTER_SECURITY_PROTOCOL.getValue()).equals("SSL") && kafkaProperties.getProperty(CruiseControlConfigurationParameters.METRICS_REPORTER_SSL_KEYSTORE_TYPE.getValue()).equals("PKCS12") && kafkaProperties.getProperty(CruiseControlConfigurationParameters.METRICS_REPORTER_SSL_KEYSTORE_LOCATION.getValue()).equals("/tmp/kafka/cluster.keystore.p12") && kafkaProperties.getProperty(CruiseControlConfigurationParameters.METRICS_REPORTER_SSL_KEYSTORE_PASSWORD.getValue()).equals("${CERTS_STORE_PASSWORD}") && kafkaProperties.getProperty(CruiseControlConfigurationParameters.METRICS_REPORTER_SSL_TRUSTSTORE_TYPE.getValue()).equals("PKCS12") && kafkaProperties.getProperty(CruiseControlConfigurationParameters.METRICS_REPORTER_SSL_TRUSTSTORE_LOCATION.getValue()).equals("/tmp/kafka/cluster.truststore.p12") && kafkaProperties.getProperty(CruiseControlConfigurationParameters.METRICS_REPORTER_SSL_TRUSTSTORE_PASSWORD.getValue()).equals("${CERTS_STORE_PASSWORD}"));
    }

    public static void verifyThatCruiseControlSamplesTopicsArePresent(long timeout) {
        int numberOfPartitionsSamplesTopic = 32;
        int numberOfReplicasSamplesTopic = 2;
        TestUtils.waitFor((String)"Verify that kafka contains cruise control topics with related configuration.", (long)Constants.GLOBAL_POLL_INTERVAL, (long)timeout, () -> {
            KafkaTopic modelTrainingSamples = (KafkaTopic)((Resource)((NonNamespaceOperation)KafkaTopicResource.kafkaTopicClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(CRUISE_CONTROL_MODEL_TRAINING_SAMPLES_TOPIC)).get();
            KafkaTopic partitionsMetricsSamples = (KafkaTopic)((Resource)((NonNamespaceOperation)KafkaTopicResource.kafkaTopicClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(CRUISE_CONTROL_PARTITION_METRICS_SAMPLES_TOPIC)).get();
            if (modelTrainingSamples != null && partitionsMetricsSamples != null) {
                boolean hasTopicCorrectPartitionsCount = modelTrainingSamples.getSpec().getPartitions() == 32 && partitionsMetricsSamples.getSpec().getPartitions() == 32;
                boolean hasTopicCorrectReplicasCount = modelTrainingSamples.getSpec().getReplicas() == 2 && partitionsMetricsSamples.getSpec().getReplicas() == 2;
                return hasTopicCorrectPartitionsCount && hasTopicCorrectReplicasCount;
            }
            LOGGER.debug("One of the samples {}, {} topics are not present", (Object)CRUISE_CONTROL_MODEL_TRAINING_SAMPLES_TOPIC, (Object)CRUISE_CONTROL_PARTITION_METRICS_SAMPLES_TOPIC);
            return false;
        });
    }

    public static void verifyThatKafkaCruiseControlMetricReporterTopicIsPresent(long timeout) {
        boolean numberOfPartitionsMetricTopic = true;
        boolean numberOfReplicasMetricTopic = true;
        TestUtils.waitFor((String)"Verify that kafka contains cruise control topics with related configuration.", (long)Constants.GLOBAL_POLL_INTERVAL, (long)timeout, () -> {
            KafkaTopic metrics = (KafkaTopic)((Resource)((NonNamespaceOperation)KafkaTopicResource.kafkaTopicClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(CRUISE_CONTROL_METRICS_TOPIC)).get();
            boolean hasTopicCorrectPartitionsCount = metrics.getSpec().getPartitions() == 1;
            boolean hasTopicCorrectReplicasCount = metrics.getSpec().getReplicas() == 1;
            return hasTopicCorrectPartitionsCount && hasTopicCorrectReplicasCount;
        });
    }

    public static void verifyThatCruiseControlTopicsArePresent() {
        CruiseControlUtils.verifyThatKafkaCruiseControlMetricReporterTopicIsPresent(Constants.GLOBAL_CRUISE_CONTROL_TIMEOUT);
        CruiseControlUtils.verifyThatCruiseControlSamplesTopicsArePresent(Constants.GLOBAL_CRUISE_CONTROL_TIMEOUT);
    }

    public static Properties getKafkaCruiseControlMetricsReporterConfiguration(String clusterName) throws IOException {
        ByteArrayInputStream configurationFileStream = new ByteArrayInputStream(((String)KubeClusterResource.kubeClient().getConfigMap(KafkaResources.kafkaMetricsAndLogConfigMapName((String)clusterName)).getData().get("server.config")).getBytes(StandardCharsets.UTF_8));
        Properties configurationOfKafka = new Properties();
        configurationOfKafka.load(configurationFileStream);
        LOGGER.info("Verifying that in {} is not present configuration related to metrics reporter", (Object)KafkaResources.kafkaMetricsAndLogConfigMapName((String)clusterName));
        Properties cruiseControlProperties = new Properties();
        for (Map.Entry<Object, Object> entry : configurationOfKafka.entrySet()) {
            if (!entry.getKey().toString().startsWith("cruise.control.metrics")) continue;
            cruiseControlProperties.put(entry.getKey(), entry.getValue());
        }
        cruiseControlProperties.put("cluster-name", clusterName);
        return cruiseControlProperties;
    }

    public static void waitForRebalanceEndpointIsReady() {
        TestUtils.waitFor((String)"Wait for rebalance endpoint is ready", (long)Constants.API_CRUISE_CONTROL_POLL, (long)Constants.API_CRUISE_CONTROL_TIMEOUT, () -> {
            String response = CruiseControlUtils.callApi(SupportedHttpMethods.POST, CruiseControlEndpoints.REBALANCE);
            LOGGER.debug("API response {}", (Object)response);
            return !response.contains("Error processing POST request '/rebalance' due to: 'com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException: com.linkedin.cruisecontrol.exception.NotEnoughValidWindowsException: ");
        });
    }

    public static enum SupportedHttpMethods {
        GET,
        POST;

    }
}

