#! /usr/bin/env python

import os
import sys

PROXY_ENV_VAR= "AProxDependencyUrl"

if len(sys.argv) < 2:
    external_indy_prefix = "https://indy.psi.redhat.com/api/"
else:
    external_indy_prefix = sys.argv[1]

try:
	internal_indy = os.environ[PROXY_ENV_VAR]
except KeyError:
	print("{} env var is not set".format(PROXY_ENV_VAR))
	sys.exit(1)
else:
	indy_suffix = internal_indy.split("/api/")[-1]
	external_indy = external_indy_prefix + indy_suffix
	print("export {}={}".format(PROXY_ENV_VAR, external_indy))
