/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.reader;

import java.util.ArrayList;
import java.util.List;
import net.sf.jxls.reader.OffsetCellCheck;
import net.sf.jxls.reader.OffsetRowCheck;
import net.sf.jxls.reader.XLSRowCursor;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;

public class OffsetRowCheckImpl
implements OffsetRowCheck {
    List cellChecks = new ArrayList();
    int offset;

    public OffsetRowCheckImpl() {
    }

    public OffsetRowCheckImpl(int offset) {
        this.offset = offset;
    }

    public OffsetRowCheckImpl(List cellChecks) {
        this.cellChecks = cellChecks;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public List getCellChecks() {
        return this.cellChecks;
    }

    public void setCellChecks(List cellChecks) {
        this.cellChecks = cellChecks;
    }

    public boolean isCheckSuccessful(HSSFRow row) {
        if (this.cellChecks.isEmpty()) {
            return this.isRowEmpty(row);
        }
        for (int i = 0; i < this.cellChecks.size(); ++i) {
            OffsetCellCheck offsetCellCheck = (OffsetCellCheck)this.cellChecks.get(i);
            if (offsetCellCheck.isCheckSuccessful(row)) continue;
            return false;
        }
        return true;
    }

    public boolean isCheckSuccessful(XLSRowCursor cursor) {
        if (!cursor.hasNext()) {
            return this.isCellChecksEmpty();
        }
        HSSFRow row = cursor.getSheet().getRow(this.offset + cursor.getCurrentRowNum());
        if (row == null) {
            return this.cellChecks.isEmpty();
        }
        return this.isCheckSuccessful(row);
    }

    private boolean isCellChecksEmpty() {
        if (this.cellChecks.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.cellChecks.size(); ++i) {
            OffsetCellCheck offsetCellCheck = (OffsetCellCheck)this.cellChecks.get(i);
            if (this.isCellCheckEmpty(offsetCellCheck)) continue;
            return false;
        }
        return true;
    }

    private boolean isCellCheckEmpty(OffsetCellCheck cellCheck) {
        if (cellCheck.getValue() == null) {
            return true;
        }
        return cellCheck.getValue().toString().trim().equals("");
    }

    public void addCellCheck(OffsetCellCheck cellCheck) {
        this.cellChecks.add(cellCheck);
    }

    private boolean isRowEmpty(HSSFRow row) {
        if (row == null) {
            return true;
        }
        for (short i = row.getFirstCellNum(); i <= row.getLastCellNum(); i = (short)(i + 1)) {
            HSSFCell cell = row.getCell(i);
            if (this.isCellEmpty(cell)) continue;
            return false;
        }
        return true;
    }

    private boolean isCellEmpty(HSSFCell cell) {
        if (cell == null) {
            return true;
        }
        switch (cell.getCellType()) {
            case 3: {
                return true;
            }
            case 1: {
                String cellValue = cell.getStringCellValue();
                return cellValue == null || cellValue.length() == 0 || cellValue.trim().length() == 0;
            }
        }
        return false;
    }
}

