/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;

public class FreeMarkerTemplate {
    private String templateText;
    private Template template;

    public FreeMarkerTemplate(String templateText) {
        AssertArgument.isNotNullAndNotEmpty(templateText, "templateText");
        this.templateText = templateText;
        StringReader templateReader = new StringReader(templateText);
        try {
            try {
                this.template = new Template("free-marker-template", (Reader)templateReader, new Configuration());
            }
            finally {
                ((Reader)templateReader).close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException.", e);
        }
    }

    public FreeMarkerTemplate(String templatePath, Class basePath) {
        AssertArgument.isNotNullAndNotEmpty(templatePath, "templatePath");
        this.templateText = templatePath;
        try {
            Configuration configuration = new Configuration();
            if (basePath != null) {
                configuration.setClassForTemplateLoading(basePath, "");
            }
            this.template = configuration.getTemplate(templatePath);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException.", e);
        }
    }

    public String getTemplateText() {
        return this.templateText;
    }

    public String apply(Object contextObject) {
        StringWriter outputWriter = new StringWriter();
        try {
            this.template.process(contextObject, (Writer)outputWriter);
        }
        catch (TemplateException e) {
            throw new SmooksException("Failed to apply template.", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException.", e);
        }
        return outputWriter.toString();
    }
}

