/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;

public class StdoutToLog4jFilter
extends FilterWriter {
    protected Log logger;
    protected StringBuilder sb = new StringBuilder();
    private static final char CR = '\r';
    private static final char LF = '\n';

    public StdoutToLog4jFilter(Writer writer) {
        super(writer);
    }

    public StdoutToLog4jFilter(Writer writer, Log log) {
        this(writer);
        this.logger = log;
    }

    @Override
    public synchronized void write(int c) throws IOException {
        this.sb.append(c);
    }

    @Override
    public synchronized void write(char[] cbuf, int off, int len) throws IOException {
        this.sb.append(cbuf, off, len);
    }

    @Override
    public synchronized void write(String str, int off, int len) throws IOException {
        this.sb.append(str.substring(off, off + len));
    }

    @Override
    public synchronized void flush() throws IOException {
        this.log();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.sb.length() != 0) {
            this.log();
        }
    }

    protected void finalize() throws Throwable {
        if (this.sb.length() != 0) {
            this.log();
        }
        super.finalize();
    }

    protected void log() {
        this.stripExtraNewLine();
        this.logBuffer(this.sb);
        this.sb.delete(0, this.sb.length());
    }

    private void logBuffer(StringBuilder sb) {
        if (this.logger == null) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)sb.toString());
        }
    }

    protected final void stripExtraNewLine() {
        int length = this.sb.length();
        if (length == 0) {
            return;
        }
        if (length == 1) {
            char last = this.sb.charAt(0);
            if (last == '\r' || last == '\n') {
                this.sb.deleteCharAt(0);
            }
        } else {
            int lastPosition = length - 1;
            char secondLast = this.sb.charAt(lastPosition);
            if (secondLast == '\r') {
                this.sb.deleteCharAt(lastPosition);
            } else if (secondLast == '\n') {
                int secondlastPosition = length - 2;
                this.sb.deleteCharAt(lastPosition);
                if (this.sb.charAt(secondlastPosition) == '\r') {
                    this.sb.deleteCharAt(secondlastPosition);
                }
            }
        }
    }
}

