/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.vfs;

import java.util.Collections;
import java.util.Date;
import org.jboss.deployment.vfs.VFSCacheStatisticsMBean;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.cache.CacheStatistics;
import org.jboss.virtual.spi.cache.VFSCache;
import org.jboss.virtual.spi.cache.VFSCacheFactory;

public class VFSCacheStatistics
implements VFSCacheStatisticsMBean {
    private CacheStatistics statistics;

    public String listCachedContexts() {
        StringBuilder builder = new StringBuilder();
        builder.append("<table><tr><th>VFSContext - root URI</th></tr>");
        for (VFSContext context : this.getStatistics().getCachedContexts()) {
            builder.append("<tr>");
            builder.append("<td>").append(context.getRootURI()).append("</td>");
            builder.append("</tr>");
        }
        builder.append("</table>");
        return builder.toString();
    }

    public int size() {
        return this.getStatistics().size();
    }

    public Date lastInsert() {
        long lastInsert = this.getStatistics().lastInsert();
        return lastInsert > 0L ? new Date(lastInsert) : null;
    }

    public String cacheToString() {
        return this.getStatistics().toString();
    }

    private CacheStatistics getStatistics() {
        if (this.statistics == null) {
            VFSCache cache = VFSCacheFactory.getInstance();
            this.statistics = cache instanceof CacheStatistics ? (CacheStatistics)CacheStatistics.class.cast(cache) : new CacheStatistics(){

                public Iterable<VFSContext> getCachedContexts() {
                    return Collections.emptySet();
                }

                public int size() {
                    return -1;
                }

                public long lastInsert() {
                    return -1L;
                }
            };
        }
        return this.statistics;
    }

    public String toString() {
        return "Noop Cache / Statistics";
    }
}

