/*
 * Copyright 2013 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jbpm.runtime.manager.impl.factory;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

import org.kie.api.task.TaskService;
import org.kie.internal.runtime.manager.TaskServiceFactory;

/**
 * CDI based task service factory that will always deliver same instance of the 
 * <code>TaskService</code> that was injected into it.
 *
 */
@ApplicationScoped
public class CDITaskServiceFactory implements TaskServiceFactory {

    @Inject
    private Instance<TaskService> taskService;    
    
    @Override
    public TaskService newTaskService() {
        return taskService.get();
    }

    @Override
    public void close() {

    }

}
