/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jsf.core;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.view.ActionSource2AttachedObjectHandler;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.Location;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.el.CompositeComponentELUtils;

public class ResetValuesActionListenerHandler
extends TagHandler
implements ActionSource2AttachedObjectHandler {
    private final TagAttribute _render = this.getRequiredAttribute("render");
    private final Collection<String> _clientIds;

    public ResetValuesActionListenerHandler(TagConfig config) {
        super(config);
        if (this._render.isLiteral()) {
            String value = this._render.getValue();
            if (value == null) {
                this._clientIds = Collections.emptyList();
            } else {
                String[] arrValue = value.split(" ");
                this._clientIds = Arrays.asList(arrValue);
            }
        } else {
            this._clientIds = null;
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        if (parent instanceof ActionSource) {
            this.applyAttachedObject(ctx.getFacesContext(), parent, false);
        } else if (UIComponent.isCompositeComponent((UIComponent)parent)) {
            if (this.getAttribute("for") == null) {
                throw new TagException(this.tag, "is nested inside a composite component but does not have a for attribute.");
            }
            FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(ctx);
            mctx.addAttachedObjectHandler(parent, (AttachedObjectHandler)this);
        } else {
            throw new TagException(this.tag, "Parent is not composite component or of type ActionSource, type is: " + parent);
        }
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        this.applyAttachedObject(context, parent, true);
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent, boolean checkForParentCC) {
        UIComponent topParentComponent = null;
        FaceletContext faceletContext = (FaceletContext)context.getAttributes().get("javax.faces.FACELET_CONTEXT");
        if (checkForParentCC) {
            FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(faceletContext);
            for (UIComponent parentComponent = parent; parentComponent != null; parentComponent = parentComponent.getParent()) {
                List<AttachedObjectHandler> handlerList;
                if (!UIComponent.isCompositeComponent((UIComponent)parentComponent) || (handlerList = mctx.getAttachedObjectHandlers(parentComponent)) == null || !handlerList.contains((Object)this)) continue;
                topParentComponent = parentComponent;
            }
        }
        ActionSource as = (ActionSource)parent;
        ActionListener listener = null;
        listener = this._render.isLiteral() ? new LiteralResetValuesActionListener(this._clientIds, topParentComponent != null ? (Location)topParentComponent.getAttributes().get("org.apache.myfaces.compositecomponent.location") : null) : new ResetValuesActionListener(this._render.getValueExpression(faceletContext, Object.class), topParentComponent != null ? (Location)topParentComponent.getAttributes().get("org.apache.myfaces.compositecomponent.location") : null);
        as.addActionListener(listener);
    }

    public String getFor() {
        TagAttribute forAttribute = this.getAttribute("for");
        if (forAttribute == null) {
            return null;
        }
        return forAttribute.getValue();
    }

    private static final String getComponentId(FacesContext facesContext, UIComponent contextComponent, String id) {
        UIComponent target = contextComponent.findComponent(id);
        if (target == null) {
            target = contextComponent.findComponent(facesContext.getNamingContainerSeparatorChar() + id);
        }
        if (target != null) {
            return target.getClientId(facesContext);
        }
        return id;
    }

    private static final class LiteralResetValuesActionListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = -9200000013153262119L;
        private Collection<String> clientIds;
        private Location topCompositeComponentReference;

        private LiteralResetValuesActionListener() {
        }

        public LiteralResetValuesActionListener(Collection<String> clientIds, Location location) {
            this.clientIds = clientIds;
            this.topCompositeComponentReference = location;
        }

        public void processAction(ActionEvent event) throws AbortProcessingException {
            FacesContext faces = FacesContext.getCurrentInstance();
            if (faces == null) {
                return;
            }
            UIViewRoot root = faces.getViewRoot();
            if (root == null) {
                return;
            }
            UIComponent contextComponent = null;
            contextComponent = this.topCompositeComponentReference != null ? ((contextComponent = CompositeComponentELUtils.getCompositeComponentBasedOnLocation(faces, event.getComponent(), this.topCompositeComponentReference)) == null ? event.getComponent() : contextComponent.getParent()) : event.getComponent();
            ArrayList<String> list = new ArrayList<String>();
            for (String id : this.clientIds) {
                list.add(ResetValuesActionListenerHandler.getComponentId(faces, contextComponent, id));
            }
            root.resetValues(faces, list);
        }
    }

    private static final class ResetValuesActionListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = -9200000013153262119L;
        private ValueExpression renderExpression;
        private Location topCompositeComponentReference;

        private ResetValuesActionListener() {
        }

        public ResetValuesActionListener(ValueExpression renderExpression, Location location) {
            this.renderExpression = renderExpression;
            this.topCompositeComponentReference = location;
        }

        public void processAction(ActionEvent event) throws AbortProcessingException {
            FacesContext faces = FacesContext.getCurrentInstance();
            if (faces == null) {
                return;
            }
            UIViewRoot root = faces.getViewRoot();
            if (root == null) {
                return;
            }
            List value = this.renderExpression.getValue(faces.getELContext());
            List<String> clientIds = null;
            if (value == null) {
                value = Collections.emptyList();
            }
            if (value instanceof Collection) {
                clientIds = value;
            } else if (value instanceof String) {
                String[] arrValue = ((String)((Object)value)).split(" ");
                clientIds = Arrays.asList(arrValue);
            } else {
                throw new IllegalArgumentException("Type " + value.getClass() + " not supported for attribute render");
            }
            UIComponent contextComponent = null;
            contextComponent = this.topCompositeComponentReference != null ? ((contextComponent = CompositeComponentELUtils.getCompositeComponentBasedOnLocation(faces, event.getComponent(), this.topCompositeComponentReference)) == null ? event.getComponent() : contextComponent.getParent()) : event.getComponent();
            ArrayList<String> list = new ArrayList<String>();
            for (String id : clientIds) {
                list.add(ResetValuesActionListenerHandler.getComponentId(faces, contextComponent, id));
            }
            root.resetValues(faces, list);
        }
    }
}

