package com.redhat.installer.installation.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ParameteredDataValidator;

public class NotEqualDataValidator extends ParameteredDataValidator {
    private AutomatedInstallData adata;
    private String messageId;

    @Override
    public Status validateData(AutomatedInstallData adata) {
        this.adata = adata;
        messageId = getParameters().get("messageId");
        String variableValue = adata.getVariable(getParameters().get("variable"));
        if (variableValue == null) {
            return Status.ERROR;
        }

        String notEqualValue = getParameters().get("value");
        if (notEqualValue == null) {
            return Status.ERROR;
        }
        return variableValue.equals(notEqualValue) ? Status.ERROR : Status.OK;
    }

    @Override
    public String getErrorMessageId() {
        return messageId;
    }

    @Override
    public String getWarningMessageId() {
        return getErrorMessageId();
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getFormattedMessage() {
        return adata.langpack.getString(getErrorMessageId());
    }
}
