package com.redhat.installer.asconfiguration.datasource.action;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.util.AbstractUIHandler;

/**
 * Created by aabulawi on 28/04/15.
 */
public class SetDatasourceDefaults implements PanelAction {

    private static final String MYSQL_CONDITION = "jdbc.driver.ismysql";
    private static final String MICROSOFT_CONDITION = "jdbc.driver.ismicrosoft";
    private static final String POSTGRES_CONDITION = "jdbc.driver.ispostgresql";
    private static final String IBM_CONDITION = "jdbc.driver.isibm";
    private static final String ORACLE_CONDITION = "jdbc.driver.isoracle";
    private static final String SYBASE_CONDITION = "jdbc.driver.issybase";
    private static final String MARIADB_CONDITION = "jdbc.driver.ismariadb";
    private static String current_condition = null;

    @Override
    public void executeAction(AutomatedInstallData adata, AbstractUIHandler handler) {
        if (!MYSQL_CONDITION.equals(current_condition) && adata.getRules().isConditionTrue(MYSQL_CONDITION)){
            adata.setVariable("jdbc.datasource.jndiname", "java:jboss/MySqlDS");
            adata.setVariable("jdbc.datasource.connectionurl", "jdbc:mysql://SERVER_NAME:PORT/DATABASE_NAME");
            adata.setVariable("jdbc.datasource.xa.databasename", "mysqldb");
            current_condition = MYSQL_CONDITION;
        }
        else if (!MICROSOFT_CONDITION.equals(current_condition) && adata.getRules().isConditionTrue(MICROSOFT_CONDITION)){
            adata.setVariable("jdbc.datasource.jndiname", "java:/MSSQLDS");
            adata.setVariable("jdbc.datasource.connectionurl", "jdbc:sqlserver://SERVER_NAME:PORT;DatabaseName=DATABASE_NAME");
            adata.setVariable("jdbc.datasource.xa.databasename", "mssqldb");
            current_condition = MICROSOFT_CONDITION;
        }
        else if (!POSTGRES_CONDITION.equals(current_condition) && adata.getRules().isConditionTrue(POSTGRES_CONDITION)){
            adata.setVariable("jdbc.datasource.jndiname", "java:jboss/PostgresDS");
            adata.setVariable("jdbc.datasource.connectionurl", "jdbc:postgresql://SERVER_NAME:PORT/DATABASE_NAME");
            adata.setVariable("jdbc.datasource.xa.databasename", "postgresdb");
            adata.setVariable("jdbc.datasource.xa.port", "5432");
            current_condition = POSTGRES_CONDITION;
        }
        else if (!IBM_CONDITION.equals(current_condition) && adata.getRules().isConditionTrue(IBM_CONDITION)){
            adata.setVariable("jdbc.datasource.jndiname", "java:/DB2DS");
            adata.setVariable("jdbc.datasource.connectionurl", "jdbc:db2://SERVER_NAME:PORT/DATABASE_NAME");
            adata.setVariable("jdbc.datasource.xa.databasename", "ibmdb2db");
            current_condition = IBM_CONDITION;
        }
        else if (!ORACLE_CONDITION.equals(current_condition) && adata.getRules().isConditionTrue(ORACLE_CONDITION)){
            adata.setVariable("jdbc.datasource.jndiname", "java:/OracleDS");
            adata.setVariable("jdbc.datasource.connectionurl", "jdbc:oracle:thin:@ORACLE_HOST:PORT:ORACLE_SID");
            current_condition = ORACLE_CONDITION;
        }
        else if (!SYBASE_CONDITION.equals(current_condition) && adata.getRules().isConditionTrue(SYBASE_CONDITION)){
            adata.setVariable("jdbc.datasource.jndiname", "java:jboss/SybaseDB");
            adata.setVariable("jdbc.datasource.connectionurl", "jdbc:sybase:Tds:localhost:5000/DATABASE?JCONNECT_VERSION=6");
            adata.setVariable("jdbc.datasource.xa.databasename", "sybase");
            adata.setVariable("jdbc.datasource.xa.port", "4100");
            current_condition = SYBASE_CONDITION;
        }
        else if (!MARIADB_CONDITION.equals(current_condition) && adata.getRules().isConditionTrue(MARIADB_CONDITION)){
            adata.setVariable("jdbc.datasource.jndiname", "java:jboss/MariaDS");
            adata.setVariable("jdbc.datasource.connectionurl", "jdbc:mariadb://SERVER_NAME:PORT/DATABASE_NAME");
            adata.setVariable("jdbc.datasource.xa.databasename", "mariadb");
            current_condition = MARIADB_CONDITION;
        }
    }

    @Override
    public void initialize(PanelActionConfiguration configuration) {

    }
}
