package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.util.AbstractUIProcessHandler;
import org.jboss.dmr.ModelNode;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by thauser on 7/15/15.
 */
public class SetServerAutoStart extends PostInstallation {
    private static final String SERVER_CONFIG = "server-config";
    private static final String AUTO_START = "auto-start";

    @Override
    protected Class getClassName() {
        return SetServerAutoStart.class;
    }

    @Override
    protected boolean performOperation() {
        return setAutoStart();
    }

    private static boolean setAutoStart() {
        List<String> servers = parser.getListProperty(SERVER_CONFIG);
        boolean result = true;
        boolean autoStart = Boolean.parseBoolean(parser.getStringProperty(AUTO_START));
        for (String server : servers) {
            result = result && serverCommands.setServerAutoStart(server, autoStart);
        }
        return result;
    }

}
