/*
 * Copyright 2015 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.optaplanner.workbench.screens.solver.client.resources.i18n;

import org.jboss.errai.ui.shared.api.annotations.TranslationKey;

/**
 * Solver Editor i18n constants
 */
public interface SolverEditorConstants {

    @TranslationKey(defaultValue = "")
    String SolverEditorPresenterSmokeTest = "SolverEditorPresenter.SmokeTest";

    @TranslationKey(defaultValue = "")
    String SolverEditorPresenterSmokeTestSuccess = "SolverEditorPresenter.SmokeTestSuccess";

    @TranslationKey(defaultValue = "")
    String SolverEditorPresenterSource = "SolverEditorPresenter.Source";

    @TranslationKey(defaultValue = "")
    String SolverResourceTypeDescription = "SolverResourceType.Description";

    @TranslationKey(defaultValue = "")
    String NewSolverHandlerDescription = "NewSolverHandler.Description";

    @TranslationKey(defaultValue = "")
    String TerminationTreeItemContentTerminationCompositionStyleHelp = "TerminationTreeItemContent.TerminationCompositionStyleHelp";

    @TranslationKey(defaultValue = "")
    String TerminationTreeItemContentTimeSpent = "TerminationTreeItemContent.TimeSpent";

    @TranslationKey(defaultValue = "")
    String TerminationTreeItemContentTimeSpentHelp = "TerminationTreeItemContent.TimeSpentHelp";

    @TranslationKey(defaultValue = "")
    String TerminationTreeItemContentUnimprovedTimeSpent = "TerminationTreeItemContent.UnimprovedTimeSpent";

    @TranslationKey(defaultValue = "")
    String TerminationTreeItemContentUnimprovedTimeSpentHelp = "TerminationTreeItemContent.UnimprovedTimeSpentHelp";

    @TranslationKey(defaultValue = "")
    String TerminationTreeItemContentBestScoreLimit = "TerminationTreeItemContent.BestScoreLimit";

    @TranslationKey(defaultValue = "")
    String TerminationTreeItemContentBestScoreLimitHelp = "TerminationTreeItemContent.BestScoreLimitHelp";

    @TranslationKey(defaultValue = "")
    String TerminationTreeItemContentBestScoreFeasible = "TerminationTreeItemContent.BestScoreFeasible";

    @TranslationKey(defaultValue = "")
    String TerminationTreeItemContentBestScoreFeasibleHelp = "TerminationTreeItemContent.BestScoreFeasibleHelp";

    @TranslationKey(defaultValue = "")
    String TerminationTreeItemContentStepCountLimit = "TerminationTreeItemContent.StepCountLimit";

    @TranslationKey(defaultValue = "")
    String TerminationTreeItemContentStepCountLimitHelp = "TerminationTreeItemContent.StepCountLimitHelp";

    @TranslationKey(defaultValue = "")
    String TerminationTreeItemContentUnimprovedStepCountLimit = "TerminationTreeItemContent.UnimprovedStepCountLimit";

    @TranslationKey(defaultValue = "")
    String TerminationTreeItemContentUnimprovedStepCountLimitHelp = "TerminationTreeItemContent.UnimprovedStepCountLimitHelp";

    @TranslationKey(defaultValue = "")
    String TerminationTreeItemContentScoreCalculationCountLimit = "TerminationTreeItemContent.ScoreCalculationCountLimit";

    @TranslationKey(defaultValue = "")
    String TerminationTreeItemContentScoreCalculationCountLimitHelp = "TerminationTreeItemContent.ScoreCalculationCountLimitHelp";

    @TranslationKey(defaultValue = "")
    String TerminationTreeItemContentViewImplNestedTermination = "TerminationTreeItemContentViewImpl.NestedTermination";

    @TranslationKey(defaultValue = "")
    String PhaseConfigFormViewImplConstructionHeuristic = "PhaseConfigFormViewImpl.ConstructionHeuristic";

    @TranslationKey(defaultValue = "")
    String PhaseConfigFormViewImplLocalSearch = "PhaseConfigFormViewImpl.LocalSearch";
}
