#!/usr/bin/env bash
# Fail immediately if one of the commands in the script fails
set -e

# Creates all required diffs using the specified create-diff.sh script

recreate_temp() {
    rm -rf "${TMP_DIR}"
    mkdir -p "${TMP_DIR}"
}

# $1: source directory
# $2: target directory
clean_copy_dir() {
    mkdir "$2"
    cp -r "$1"* "$2"
}

# $1: diff name
# $2: relative path to latest GA build dir (older build)
# $3: relative path to latest patch build dir (newer build)
# $4: comma separated list of dirs that will be included as a whole (not creating diffs for them)
create_diff() {
    echo ">>> Creating diff for RHPAM $1"
    recreate_temp
    # copy the sources as we will make changes there that can not be undone
    clean_copy_dir "${BASEDIR}/$2/" $NEW_VERSION_DIR
    clean_copy_dir "${BASEDIR}/$3/" $OLD_VERSION_DIR
    sh "${SCRIPTS_PATH}/create-diff.sh" "${BASEDIR}/diffs/rhpam-${1}" "${NEW_VERSION_DIR}" "${OLD_VERSION_DIR}" "rhpam-${1}" "${PATCH_VERSION}"\
     "${CURRENT_UPDATES_LISTS_DIR}" "${PREVIOUS_UPDATES_LISTS_DIR}" "$4" "$PREVIOUS_CHECKSUMS_DIR" "${CURRENT_CHECKSUMS_DIR}"
}

SCRIPTS_PATH="$1"
BASEDIR="$2"
PATCH_VERSION="$3"

TMP_DIR="${BASEDIR}/create-all-diffs-tmp"
NEW_VERSION_DIR="${TMP_DIR}/new-version"
OLD_VERSION_DIR="${TMP_DIR}/old-version"

CURRENT_UPDATES_LISTS_DIR="${BASEDIR}/updates-lists"
PREVIOUS_UPDATES_LISTS_DIR="${BASEDIR}/previous-updates-lists"
rm -rf "${CURRENT_UPDATES_LISTS_DIR}"
mkdir "${CURRENT_UPDATES_LISTS_DIR}"

CURRENT_CHECKSUMS_DIR="${BASEDIR}/checksums"
rm -rf "${CURRENT_CHECKSUMS_DIR}"
mkdir "${CURRENT_CHECKSUMS_DIR}"

PREVIOUS_CHECKSUMS_DIR="${BASEDIR}/previous-checksums"

# RHPAM diffs
create_diff "business-central-eap7-deployable"\
 "business-central-eap7-deployable-latest-release/jboss-eap-7.2/standalone/deployments/business-central.war/"\
 "business-central-eap7-deployable-latest-patch/jboss-eap-7.2/standalone/deployments/business-central.war/"\
 ""

create_diff "kie-server-ee8"\
 "kie-server-ee8-latest-release/kie-server.war/"\
 "kie-server-ee8-latest-patch/kie-server.war/"\
 ""

create_diff "controller-ee7"\
 "controller-ee7-latest-release/controller.war/"\
 "controller-ee7-latest-patch/controller.war/"\
 ""

create_diff "kie-server-jws"\
 "kie-server-jws-latest-release/kie-server.war/"\
 "kie-server-jws-latest-patch/kie-server.war/"\
 ""

create_diff "controller-jws"\
 "controller-jws-latest-release/controller.war/"\
 "controller-jws-latest-patch/controller.war"\
 ""
