package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;

import org.jbpm.gd.jpdl.model.ConfigType;
import org.jbpm.gd.jpdl.model.Controller;
import org.jbpm.gd.jpdl.model.AbstractJpdlElement;

public class ControllerDomAdapter extends JpdlElementDomAdapter {
	
	protected void initialize(AbstractJpdlElement jpdlElement) {
		super.initialize(jpdlElement);
		Controller controller = (Controller)jpdlElement;
		controller.setConfigInfoString(getTextContent());
		controller.setClassName(getAttribute("class"));
		controller.setConfigType(getAttribute("config-type"));
		controller.addPropertyChangeListener(this);
	}
	
	protected void initialize() {
		super.initialize();
		Controller controller = (Controller)getJpdlElement();
		if (controller != null ) {
			setTextContent(controller.getConfigInfoString());
			setAttribute("class", controller.getClassName());
			setAttribute("config-type", controller.getConfigType());
		}
	}
	
	protected String getDefaultValue(String attributeName) {
		if ("config-type".equals(attributeName)) {
			return ConfigType.FIELD;
		} else {
			return super.getDefaultValue(attributeName);
		}
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("configInfoString".equals(evt.getPropertyName())) {
			setTextContent((String)evt.getNewValue());
		} else if ("className".equals(evt.getPropertyName())) {
			setAttribute("class", (String)evt.getNewValue());
		} else if ("configType".equals(evt.getPropertyName())) {
			setAttribute("config-type", (String)evt.getNewValue());
		}
	}
	
	protected void doModelUpdate(String name, String newValue) {
		Controller controller = (Controller)getJpdlElement();
		if ("#text".equals(name)) {
			controller.setConfigInfoString(newValue);
		} else if ("class".equals(name)) {
			controller.setClassName(newValue);
		} else if ("config-type".equals(name)) {
			controller.setConfigType(newValue);
		}
	}
	
	protected void doModelAdd(JpdlElementDomAdapter child) {
		// a controller cannot have any child nodes
	}
	
	protected void doModelRemove(JpdlElementDomAdapter child) {
		// a controller cannot have any child nodes
	}
	
}
