package org.jbpm.gd.jpdl.ui.properties;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.CancelTimer;

public class CancelTimerConfigurationComposite implements SelectionListener, FocusListener {
	
	public static CancelTimerConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
		CancelTimerConfigurationComposite result = new CancelTimerConfigurationComposite();
		result.widgetFactory = widgetFactory;
		result.parent = parent;
		result.create();
		return result;
	}
	
	private TabbedPropertySheetWidgetFactory widgetFactory;
	private Composite parent;
	
	private Group cancelTimerInfoGroup;
	private Label nameLabel;
	private Text nameText;
	
	private CancelTimer cancelTimer;
	
	private CancelTimerConfigurationComposite() {}
	
	public void setCancelTimer(CancelTimer cancelTimer) {
		if (this.cancelTimer == cancelTimer) return;
		unhookListeners();
		this.cancelTimer = cancelTimer;
		if (cancelTimer == null) {
			clearControls();
		} else {
			updateControls();
			hookListeners();
		}
	}
	
	public CancelTimer getCancelTimer() {
		return cancelTimer;
	}
	
	private void hookListeners() {
		nameText.addSelectionListener(this);
		nameText.addFocusListener(this);
	}
	
	private void unhookListeners() {
		nameText.removeSelectionListener(this);
		nameText.removeFocusListener(this);
	}
	
	private void clearControls() {
		nameText.setText("");
	}
	
	private void updateControls() {
		nameText.setText(cancelTimer.getName() == null ? "" : cancelTimer.getName());
	}
	
	private void create() {
		cancelTimerInfoGroup = widgetFactory.createGroup(parent, "Cancel Timer Info");
		cancelTimerInfoGroup.setLayout(new FormLayout());
		cancelTimerInfoGroup.setLayoutData(createCancelTimerInfoGroupLayoutData());
		nameLabel = widgetFactory.createLabel(cancelTimerInfoGroup, "Name");
		nameText = widgetFactory.createText(cancelTimerInfoGroup, "");
		nameLabel.setLayoutData(createNameLabelLayoutData());
		nameText.setLayoutData(createNameTextLayoutData());
	}
	
	private FormData createNameLabelLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 5);
		data.top = new FormAttachment(0, 5);
		return data;
	}
	
	private FormData createNameTextLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(nameLabel, 5);
		data.top = new FormAttachment(0, 5);
		data.right = new FormAttachment(50, 0);
		data.bottom = new FormAttachment(100, -5);
		return data;
	}
	
	private FormData createCancelTimerInfoGroupLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 5);
		data.top = new FormAttachment(0, 5);
		data.right = new FormAttachment(100, -5);
		return data;
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		if (e.widget == nameText) {
			cancelTimer.setName(nameText.getText());
		}
	}

	public void widgetSelected(SelectionEvent e) {
	}

	public void focusGained(FocusEvent e) {
	}

	public void focusLost(FocusEvent e) {
		if (e.widget == nameText) {
			cancelTimer.setName(nameText.getText());
		}
	}
	
}
