/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base;

import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.LockFailedException;
import org.modeshape.graph.connector.base.Node;
import org.modeshape.graph.connector.base.Repository;
import org.modeshape.graph.connector.base.Transaction;
import org.modeshape.graph.connector.base.Workspace;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.request.LockBranchRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public abstract class BaseTransaction<NodeType extends Node, WorkspaceType extends Workspace>
implements Transaction<NodeType, WorkspaceType> {
    protected final UUID rootNodeUuid;
    protected final ExecutionContext context;
    protected final PathFactory pathFactory;
    protected final NameFactory nameFactory;
    protected final PropertyFactory propertyFactory;
    protected final ValueFactories valueFactories;
    protected final Location rootLocation;
    private final Repository<NodeType, WorkspaceType> repository;

    protected BaseTransaction(ExecutionContext context, Repository<NodeType, WorkspaceType> repository, UUID rootNodeUuid) {
        this.rootNodeUuid = rootNodeUuid;
        this.context = context;
        this.propertyFactory = context.getPropertyFactory();
        this.valueFactories = context.getValueFactories();
        this.pathFactory = this.valueFactories.getPathFactory();
        this.nameFactory = this.valueFactories.getNameFactory();
        this.repository = repository;
        this.rootLocation = Location.create(this.pathFactory.createRootPath(), rootNodeUuid);
    }

    public Location getRootLocation() {
        return this.rootLocation;
    }

    public UUID getRootUuid() {
        return this.rootNodeUuid;
    }

    protected String readable(Object obj) {
        return this.valueFactories.getStringFactory().create(obj);
    }

    @Override
    public ExecutionContext getContext() {
        return this.context;
    }

    protected Repository<NodeType, WorkspaceType> getRepository() {
        return this.repository;
    }

    @Override
    public Set<String> getWorkspaceNames() {
        return this.repository.getWorkspaceNames();
    }

    @Override
    public NodeType getRootNode(WorkspaceType workspace) {
        return this.getNode(workspace, this.rootLocation);
    }

    protected NodeType getNode(WorkspaceType workspace, Path path, Location location) {
        NodeType node = this.getRootNode(workspace);
        for (Path.Segment segment : path) {
            NodeType child = this.getChild(workspace, node, segment);
            if (child == null) {
                LinkedList<Path.Segment> segments = new LinkedList<Path.Segment>();
                for (Path.Segment seg : path) {
                    if (seg == segment) break;
                    segments.add(seg);
                }
                Path lowestExisting = this.pathFactory.createAbsolutePath(segments);
                throw new PathNotFoundException(location, lowestExisting, GraphI18n.nodeDoesNotExist.text(new Object[]{path}));
            }
            node = child;
        }
        return node;
    }

    @Override
    public Path pathFor(WorkspaceType workspace, NodeType node) {
        assert (node != null);
        assert (this.pathFactory != null);
        LinkedList<Path.Segment> segments = new LinkedList<Path.Segment>();
        do {
            segments.addFirst(node.getName());
        } while ((node = this.getParent(workspace, node)) != null);
        segments.removeFirst();
        return this.pathFactory.createAbsolutePath(segments);
    }

    @Override
    public NodeType getFirstChild(WorkspaceType workspace, NodeType parent, Name childName) {
        for (Node child : this.getChildren(workspace, parent)) {
            if (!child.getName().getName().equals(childName)) continue;
            return (NodeType)child;
        }
        return null;
    }

    @Override
    public void lockNode(WorkspaceType workspace, NodeType node, LockBranchRequest.LockScope lockScope, long lockTimeoutInMillis) throws LockFailedException {
    }

    @Override
    public void unlockNode(WorkspaceType workspace, NodeType node) {
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
    }
}

