/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.modeshape.common.text.Inflector;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.property.InvalidPathException;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.basic.AbstractPath;
import org.modeshape.graph.property.basic.BasicPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class RootPath
extends AbstractPath {
    private static final long serialVersionUID = 1L;
    public static final Path INSTANCE = new RootPath();
    private static final Path.Segment[] EMPTY_SEGMENT_ARRAY = new Path.Segment[0];
    private static final List<Path.Segment> EMPTY_SEGMENT_LIST = Collections.emptyList();

    private RootPath() {
    }

    @Override
    public Path getAncestor(int degree) {
        CheckArg.isNonNegative((int)degree, (String)"degree");
        if (degree == 0) {
            return this;
        }
        String msg = GraphI18n.pathAncestorDegreeIsInvalid.text(new Object[]{this.getString(), Inflector.getInstance().ordinalize(degree)});
        throw new InvalidPathException(msg);
    }

    @Override
    protected Iterator<Path.Segment> getSegmentsOfParent() {
        return EMPTY_PATH_ITERATOR;
    }

    @Override
    public Path getCanonicalPath() {
        return this;
    }

    @Override
    public Path getCommonAncestor(Path that) {
        CheckArg.isNotNull((Object)that, (String)"that");
        return this;
    }

    @Override
    public Path.Segment getLastSegment() {
        return null;
    }

    @Override
    public boolean endsWith(Name nameOfLastSegment) {
        return false;
    }

    @Override
    public boolean endsWith(Name nameOfLastSegment, int snsIndex) {
        return false;
    }

    @Override
    public Path getNormalizedPath() {
        return this;
    }

    @Override
    public Path relativeToRoot() {
        return BasicPath.SELF_PATH;
    }

    @Override
    public Path resolve(Path relativePath) {
        CheckArg.isNotNull((Object)relativePath, (String)"relative path");
        if (relativePath.isAbsolute()) {
            String msg = GraphI18n.pathIsNotRelative.text(new Object[]{relativePath});
            throw new InvalidPathException(msg);
        }
        return new BasicPath(relativePath.getSegmentsList(), true).getNormalizedPath();
    }

    @Override
    public Path getParent() {
        return null;
    }

    @Override
    public Path.Segment getSegment(int index) {
        CheckArg.isNonNegative((int)index, (String)"index");
        EMPTY_SEGMENT_LIST.get(index);
        return null;
    }

    @Override
    public Path.Segment[] getSegmentsArray() {
        return EMPTY_SEGMENT_ARRAY;
    }

    @Override
    public List<Path.Segment> getSegmentsList() {
        return EMPTY_SEGMENT_LIST;
    }

    @Override
    public String getString() {
        return Path.DELIMITER_STR;
    }

    @Override
    public String getString(TextEncoder encoder) {
        return Path.DELIMITER_STR;
    }

    @Override
    public String getString(NamespaceRegistry namespaceRegistry) {
        CheckArg.isNotNull((Object)namespaceRegistry, (String)"namespaceRegistry");
        return Path.DELIMITER_STR;
    }

    @Override
    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder) {
        CheckArg.isNotNull((Object)namespaceRegistry, (String)"namespaceRegistry");
        return Path.DELIMITER_STR;
    }

    @Override
    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder, TextEncoder delimiterEncoder) {
        return delimiterEncoder == null ? DELIMITER_STR : delimiterEncoder.encode(DELIMITER_STR);
    }

    @Override
    public boolean hasSameAncestor(Path that) {
        CheckArg.isNotNull((Object)that, (String)"that");
        return true;
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public boolean isAncestorOf(Path decendant) {
        CheckArg.isNotNull((Object)decendant, (String)"decendant");
        return !decendant.isRoot();
    }

    @Override
    public boolean isAtOrAbove(Path other) {
        CheckArg.isNotNull((Object)other, (String)"other");
        return true;
    }

    @Override
    public boolean isAtOrBelow(Path other) {
        CheckArg.isNotNull((Object)other, (String)"other");
        return other.isRoot();
    }

    @Override
    public boolean isDecendantOf(Path ancestor) {
        CheckArg.isNotNull((Object)ancestor, (String)"ancestor");
        return false;
    }

    @Override
    public boolean isNormalized() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    @Override
    public boolean isSameAs(Path other) {
        CheckArg.isNotNull((Object)other, (String)"other");
        return other.isRoot();
    }

    @Override
    public Iterator<Path.Segment> iterator() {
        return EMPTY_SEGMENT_LIST.iterator();
    }

    @Override
    public Iterator<Path> pathsFromRoot() {
        return new AbstractPath.SingleIterator<Path>(this);
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Path subpath(int beginIndex) {
        CheckArg.isNonNegative((int)beginIndex, (String)"beginIndex");
        if (beginIndex == 0) {
            return this;
        }
        EMPTY_SEGMENT_LIST.get(1);
        return null;
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        CheckArg.isNonNegative((int)beginIndex, (String)"beginIndex");
        CheckArg.isNonNegative((int)endIndex, (String)"endIndex");
        if (endIndex >= 1) {
            EMPTY_SEGMENT_LIST.get(endIndex);
        }
        return this;
    }

    @Override
    public int compareTo(Path other) {
        return other.isRoot() ? 0 : -1;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Path) {
            Path that = (Path)obj;
            return that.isRoot();
        }
        return false;
    }
}

