/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.model.Visitors;

@Immutable
public class ChildNode
implements Constraint {
    private static final long serialVersionUID = 1L;
    private final SelectorName selectorName;
    private final String parentPath;
    private final int hc;

    public ChildNode(SelectorName selectorName, String parentPath) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotNull((Object)parentPath, (String)"parentPath");
        this.selectorName = selectorName;
        this.parentPath = parentPath;
        this.hc = HashCode.compute((Object[])new Object[]{this.selectorName, this.parentPath});
    }

    public final SelectorName selectorName() {
        return this.selectorName;
    }

    public final String parentPath() {
        return this.parentPath;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ChildNode) {
            ChildNode that = (ChildNode)obj;
            if (this.hc != that.hc) {
                return false;
            }
            if (!this.selectorName.equals(that.selectorName)) {
                return false;
            }
            return this.parentPath.equals(that.parentPath);
        }
        return false;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

