/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeTypeIterator;
import net.jcip.annotations.Immutable;
import org.modeshape.web.jcr.rest.client.RestClientI18n;
import org.modeshape.web.jcr.rest.client.domain.ChildNodeDefinition;
import org.modeshape.web.jcr.rest.client.domain.IModeShapeObject;
import org.modeshape.web.jcr.rest.client.domain.ItemDefinition;
import org.modeshape.web.jcr.rest.client.domain.PropertyDefinition;

@Immutable
public class NodeType
implements IModeShapeObject,
javax.jcr.nodetype.NodeType {
    private final String name;
    private final boolean isAbstract;
    private final boolean isMixin;
    private final boolean isQueryable;
    private final boolean hasOrderableChildNodes;
    private final String primaryItemName;
    private final Map<PropertyDefinition.Id, PropertyDefinition> propertyDefinitions;
    private final Map<ChildNodeDefinition.Id, ChildNodeDefinition> childNodeDefinitions;
    private final List<String> declaredSuperTypes;
    private final Map<String, NodeType> nodeTypes;
    private List<NodeType> allSuperTypes;
    private Set<String> allSuperTypeNames;
    private Map<PropertyDefinition.Id, PropertyDefinition> allPropertyDefinitions;
    private Map<ChildNodeDefinition.Id, ChildNodeDefinition> allChildNodeDefinitions;

    public NodeType(String name, boolean isMixin, boolean isAbstract, List<String> superTypes, List<PropertyDefinition> propertyDefinitions, List<ChildNodeDefinition> childNodeDefinitions, String primaryItemName, boolean hasOrderableChildNodes, boolean isQueryable, Map<String, NodeType> nodeTypes) {
        assert (name != null);
        this.name = name;
        this.isMixin = isMixin;
        this.isAbstract = isAbstract;
        this.isQueryable = isQueryable;
        this.hasOrderableChildNodes = hasOrderableChildNodes;
        this.primaryItemName = primaryItemName;
        List<String> list = this.declaredSuperTypes = superTypes != null ? superTypes : Collections.emptyList();
        if (propertyDefinitions != null && !propertyDefinitions.isEmpty()) {
            HashMap<PropertyDefinition.Id, PropertyDefinition> propDefns = new HashMap<PropertyDefinition.Id, PropertyDefinition>();
            for (PropertyDefinition propDefn : propertyDefinitions) {
                propDefns.put(propDefn.id(), propDefn);
            }
            this.propertyDefinitions = propDefns;
        } else {
            this.propertyDefinitions = Collections.emptyMap();
        }
        if (childNodeDefinitions != null && !childNodeDefinitions.isEmpty()) {
            HashMap<ChildNodeDefinition.Id, ChildNodeDefinition> nodeDefns = new HashMap<ChildNodeDefinition.Id, ChildNodeDefinition>();
            for (ChildNodeDefinition nodeDefn : childNodeDefinitions) {
                nodeDefns.put(nodeDefn.id(), nodeDefn);
            }
            this.childNodeDefinitions = nodeDefns;
        } else {
            this.childNodeDefinitions = Collections.emptyMap();
        }
        this.nodeTypes = nodeTypes != null ? nodeTypes : new HashMap();
        this.nodeTypes.put(this.name, this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public javax.jcr.nodetype.NodeType[] getDeclaredSupertypes() {
        return ItemDefinition.nodeTypes(this.declaredSuperTypes, this.nodeTypes);
    }

    @Override
    public javax.jcr.nodetype.NodeType[] getSupertypes() {
        List<NodeType> allSuperTypes = this.allSuperTypes();
        return allSuperTypes.toArray(new javax.jcr.nodetype.NodeType[allSuperTypes.size()]);
    }

    @Override
    public String[] getDeclaredSupertypeNames() {
        return ItemDefinition.toArray(this.declaredSuperTypes);
    }

    @Override
    public NodeTypeIterator getDeclaredSubtypes() {
        ArrayList<NodeType> results = new ArrayList<NodeType>();
        for (NodeType nodeType : this.nodeTypes.values()) {
            if (nodeType == this || !nodeType.declaredSuperTypes.contains(this.name)) continue;
            results.add(nodeType);
        }
        return new NodeTypes(results);
    }

    @Override
    public NodeTypeIterator getSubtypes() {
        ArrayList<NodeType> results = new ArrayList<NodeType>();
        for (NodeType nodeType : this.nodeTypes.values()) {
            if (nodeType == this || !nodeType.allSuperTypeNames().contains(this.name)) continue;
            results.add(nodeType);
        }
        return new NodeTypes(results);
    }

    protected List<NodeType> allSuperTypes() {
        if (this.allSuperTypes == null) {
            NodeType ntBase;
            ArrayList<NodeType> allSuperTypes = new ArrayList<NodeType>();
            HashSet<String> allSuperTypeNames = new HashSet<String>();
            for (String superTypeName : this.declaredSuperTypes) {
                NodeType superType = this.nodeTypes.get(superTypeName);
                if (superType == null) continue;
                allSuperTypes.add(superType);
                allSuperTypeNames.add(superType.getName());
                allSuperTypes.addAll(superType.allSuperTypes());
                allSuperTypeNames.addAll(superType.allSuperTypeNames());
            }
            if (allSuperTypes.isEmpty() && !this.isMixin && (ntBase = this.nodeTypes.get("nt:base")) != null) {
                allSuperTypes.add(ntBase);
                allSuperTypeNames.add(ntBase.getName());
            }
            this.allSuperTypes = allSuperTypes;
            this.allSuperTypeNames = allSuperTypeNames;
        }
        return this.allSuperTypes;
    }

    protected Set<String> allSuperTypeNames() {
        this.allSuperTypes();
        return this.allSuperTypeNames;
    }

    @Override
    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        return this.childNodeDefinitions.values().toArray(new NodeDefinition[this.childNodeDefinitions.size()]);
    }

    @Override
    public NodeDefinition[] getChildNodeDefinitions() {
        Collection<ChildNodeDefinition> allDefns = this.allChildNodeDefinitions();
        return allDefns.toArray(new NodeDefinition[allDefns.size()]);
    }

    protected Collection<ChildNodeDefinition> declaredChildNodeDefinitions() {
        return this.childNodeDefinitions.values();
    }

    protected Collection<ChildNodeDefinition> allChildNodeDefinitions() {
        if (this.allChildNodeDefinitions == null) {
            HashMap<ChildNodeDefinition.Id, ChildNodeDefinition> allDefns = new HashMap<ChildNodeDefinition.Id, ChildNodeDefinition>();
            allDefns.putAll(this.childNodeDefinitions);
            for (NodeType superType : this.allSuperTypes()) {
                for (ChildNodeDefinition childDefn : superType.declaredChildNodeDefinitions()) {
                    if (allDefns.containsKey(childDefn.id())) continue;
                    allDefns.put(childDefn.id(), childDefn);
                }
            }
            this.allChildNodeDefinitions = allDefns;
        }
        return this.allChildNodeDefinitions.values();
    }

    @Override
    public javax.jcr.nodetype.PropertyDefinition[] getDeclaredPropertyDefinitions() {
        return this.propertyDefinitions.values().toArray(new javax.jcr.nodetype.PropertyDefinition[this.propertyDefinitions.size()]);
    }

    @Override
    public javax.jcr.nodetype.PropertyDefinition[] getPropertyDefinitions() {
        Collection<PropertyDefinition> allDefns = this.allPropertyDefinitions();
        return allDefns.toArray(new javax.jcr.nodetype.PropertyDefinition[allDefns.size()]);
    }

    protected Collection<PropertyDefinition> declaredPropertyDefinitions() {
        return this.propertyDefinitions.values();
    }

    protected Collection<PropertyDefinition> allPropertyDefinitions() {
        if (this.allPropertyDefinitions == null) {
            HashMap<PropertyDefinition.Id, PropertyDefinition> allDefns = new HashMap<PropertyDefinition.Id, PropertyDefinition>();
            allDefns.putAll(this.propertyDefinitions);
            for (NodeType superType : this.allSuperTypes()) {
                for (PropertyDefinition propDefn : superType.declaredPropertyDefinitions()) {
                    if (allDefns.containsKey(propDefn.id())) continue;
                    allDefns.put(propDefn.id(), propDefn);
                }
            }
            this.allPropertyDefinitions = allDefns;
        }
        return this.allPropertyDefinitions.values();
    }

    @Override
    public String getPrimaryItemName() {
        return this.primaryItemName;
    }

    @Override
    public boolean hasOrderableChildNodes() {
        return this.hasOrderableChildNodes;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isMixin() {
        return this.isMixin;
    }

    @Override
    public boolean isQueryable() {
        return this.isQueryable;
    }

    @Override
    public boolean isNodeType(String nodeTypeName) {
        if (nodeTypeName == null) {
            return false;
        }
        if (this.name.equals(nodeTypeName)) {
            return true;
        }
        return this.allSuperTypeNames().contains(nodeTypeName);
    }

    @Override
    public String getShortDescription() {
        return RestClientI18n.nodeTypeShortDescription.text(this.name);
    }

    @Override
    public boolean canAddChildNode(String childNodeName) {
        return false;
    }

    @Override
    public boolean canAddChildNode(String childNodeName, String nodeTypeName) {
        return false;
    }

    @Override
    public boolean canRemoveItem(String itemName) {
        return false;
    }

    @Override
    public boolean canRemoveNode(String nodeName) {
        return false;
    }

    @Override
    public boolean canRemoveProperty(String propertyName) {
        return false;
    }

    @Override
    public boolean canSetProperty(String propertyName, Value value) {
        return false;
    }

    @Override
    public boolean canSetProperty(String propertyName, Value[] values) {
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NodeType) {
            // empty if block
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.name);
        sb.append(']');
        if (this.getDeclaredSupertypeNames().length != 0) {
            sb.append(" > ");
            boolean first = true;
            for (String typeName : this.getDeclaredSupertypeNames()) {
                if (typeName == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(typeName);
            }
        }
        if (this.isAbstract()) {
            sb.append(" abstract");
        }
        if (this.isMixin()) {
            sb.append(" mixin");
        }
        if (!this.isQueryable()) {
            sb.append(" noquery");
        }
        if (this.hasOrderableChildNodes()) {
            sb.append(" orderable");
        }
        if (this.getPrimaryItemName() != null) {
            sb.append(" primaryitem ").append(this.getPrimaryItemName());
        }
        for (PropertyDefinition propDefn : this.declaredPropertyDefinitions()) {
            sb.append('\n').append(propDefn);
        }
        for (ChildNodeDefinition childDefn : this.declaredChildNodeDefinitions()) {
            sb.append('\n').append(childDefn);
        }
        sb.append('\n');
        return sb.toString();
    }

    protected static class NodeTypes
    implements NodeTypeIterator {
        private final List<NodeType> nodeTypes;
        private final Iterator<NodeType> iter;
        private long position;

        protected NodeTypes(List<NodeType> nodeTypes) {
            this.nodeTypes = nodeTypes;
            this.iter = nodeTypes.iterator();
            this.position = 0L;
        }

        @Override
        public javax.jcr.nodetype.NodeType nextNodeType() {
            NodeType next = this.iter.next();
            ++this.position;
            return next;
        }

        @Override
        public long getPosition() {
            return this.position;
        }

        @Override
        public long getSize() {
            return this.nodeTypes.size();
        }

        @Override
        public void skip(long skipNum) {
            for (long i = 0L; i != skipNum; ++i) {
                if (!this.hasNext()) {
                    return;
                }
                this.nextNodeType();
            }
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            return this.nextNodeType();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

