/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.LinkedHashMap;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.lang.TranslatableProcedureContainer;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class Update
extends TranslatableProcedureContainer {
    private GroupSymbol group;
    private SetClauseList changeList = new SetClauseList();
    private Criteria criteria;

    public Update() {
    }

    @Override
    public int getType() {
        return 3;
    }

    public Update(GroupSymbol group, SetClauseList changeList) {
        this.group = group;
        this.changeList = changeList;
    }

    public Update(GroupSymbol group, SetClauseList changeList, Criteria criteria) {
        this(group, changeList);
        this.criteria = criteria;
    }

    @Override
    public GroupSymbol getGroup() {
        return this.group;
    }

    public void setGroup(GroupSymbol group) {
        this.group = group;
    }

    public void setChangeList(SetClauseList changeList) {
        this.changeList = changeList;
    }

    public SetClauseList getChangeList() {
        return this.changeList;
    }

    public void addChange(ElementSymbol id, Expression value) {
        this.changeList.addClause(id, value);
    }

    @Override
    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.group});
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.changeList});
        if (this.criteria != null) {
            myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.criteria});
        }
        return myHash;
    }

    @Override
    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Update)) {
            return false;
        }
        Update other = (Update)obj;
        return EquivalenceUtil.areEqual((Object)this.getGroup(), (Object)other.getGroup()) && this.getChangeList().equals(other.getChangeList()) && EquivalenceUtil.areEqual((Object)this.getCriteria(), (Object)other.getCriteria());
    }

    @Override
    public Object clone() {
        Update copy = new Update();
        if (this.group != null) {
            copy.setGroup((GroupSymbol)this.group.clone());
        }
        copy.setChangeList((SetClauseList)this.changeList.clone());
        if (this.criteria != null) {
            copy.setCriteria((Criteria)this.criteria.clone());
        }
        this.copyMetadataState(copy);
        return copy;
    }

    public List getProjectedSymbols() {
        return Command.getUpdateCommandSymbol();
    }

    @Override
    public boolean areResultsCachable() {
        return false;
    }

    @Override
    public LinkedHashMap<ElementSymbol, Expression> getProcedureParameters() {
        LinkedHashMap<ElementSymbol, Expression> map = new LinkedHashMap<ElementSymbol, Expression>();
        for (SetClause setClause : this.getChangeList().getClauses()) {
            ElementSymbol symbol = (ElementSymbol)setClause.getSymbol().clone();
            symbol.setName("INPUTS." + symbol.getShortCanonicalName());
            map.put(symbol, setClause.getValue());
        }
        return map;
    }
}

