/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.proc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class CreateUpdateProcedureCommand
extends Command {
    private Block block;
    private Map symbolMap;
    private Command userCommand;
    private boolean isUpdateProcedure = true;
    private List projectedSymbols;
    private GroupSymbol virtualGroup;
    private Command resultsCommand;

    public CreateUpdateProcedureCommand() {
    }

    public CreateUpdateProcedureCommand(Block block) {
        this.block = block;
    }

    @Override
    public int getType() {
        return 7;
    }

    public Block getBlock() {
        return this.block;
    }

    public void setBlock(Block block) {
        this.block = block;
    }

    public void setUserCommand(Command command) {
        this.userCommand = command;
    }

    public Command getUserCommand() {
        return this.userCommand;
    }

    public void setSymbolMap(Map symbolMap) {
        this.symbolMap = symbolMap;
    }

    public Map getSymbolMap() {
        return this.symbolMap;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        CreateUpdateProcedureCommand copy = new CreateUpdateProcedureCommand();
        if (this.block != null) {
            copy.setBlock((Block)this.block.clone());
        }
        if (this.getSymbolMap() != null) {
            copy.setSymbolMap(new HashMap(this.getSymbolMap()));
        }
        copy.setUpdateProcedure(this.isUpdateProcedure());
        if (this.projectedSymbols != null) {
            copy.setProjectedSymbols(new ArrayList(this.projectedSymbols));
        }
        if (this.virtualGroup != null) {
            copy.virtualGroup = (GroupSymbol)this.virtualGroup.clone();
        }
        this.copyMetadataState(copy);
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CreateUpdateProcedureCommand)) {
            return false;
        }
        CreateUpdateProcedureCommand other = (CreateUpdateProcedureCommand)obj;
        return this.sameOptionAndHint(other) && EquivalenceUtil.areEqual((Object)this.getBlock(), (Object)other.getBlock());
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.getBlock()});
        return myHash;
    }

    @Override
    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public List getProjectedSymbols() {
        if (this.projectedSymbols != null) {
            return this.projectedSymbols;
        }
        if (!this.isUpdateProcedure) {
            if (this.resultsCommand == null) {
                return Collections.EMPTY_LIST;
            }
            this.setProjectedSymbols(this.resultsCommand.getProjectedSymbols());
            return this.projectedSymbols;
        }
        this.projectedSymbols = Command.getUpdateCommandSymbol();
        return this.projectedSymbols;
    }

    public boolean isUpdateProcedure() {
        return this.isUpdateProcedure;
    }

    public void setUpdateProcedure(boolean isUpdateProcedure) {
        this.isUpdateProcedure = isUpdateProcedure;
    }

    public void setProjectedSymbols(List projSymbols) {
        this.projectedSymbols = projSymbols;
    }

    public Command getResultsCommand() {
        return this.resultsCommand;
    }

    public void setResultsCommand(Command command) {
        this.resultsCommand = command;
    }

    @Override
    public boolean areResultsCachable() {
        if (this.isUpdateProcedure()) {
            return false;
        }
        return Query.areResultsCachable(this.getProjectedSymbols());
    }

    public GroupSymbol getVirtualGroup() {
        return this.virtualGroup;
    }

    public void setVirtualGroup(GroupSymbol virtualGroup) {
        this.virtualGroup = virtualGroup;
    }
}

