/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.model.ui.IAttributeErrorProvider;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.attribute.AttributeContentProposalProviderFactory;
import org.jboss.tools.common.model.ui.attribute.IListContentProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.widgets.BorderedControl;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.widgets.border.Border;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBoxFieldEditor
extends ExtendedFieldEditor
implements IFieldEditor,
IPropertyFieldEditor,
IPropertyChangeListener,
PropertyChangeListener {
    IPropertyEditor propertyEditor;
    IValueChangeListener valueChangeListener;
    IValueProvider valueProvider;
    ILabelProvider labelProvider;
    IListContentProvider listContentProvider;
    private boolean dropDown = false;
    private String stringValue = "";
    private boolean isValid;
    public static int UNLIMITED = -1;
    private int textLimit = UNLIMITED;
    private int widthInChars = UNLIMITED;
    private Combo comboField;
    private String[] tags = new String[0];
    private static final int defaultStyle = 2048;
    boolean modifyLock = false;
    private KeyAdapter keyAdapter;
    private FocusAdapter focusAdapter;
    private ModifyListener modifyListener;
    private DisposeListener disposeListener;
    Object[] elements;

    public ComboBoxFieldEditor() {
    }

    public ComboBoxFieldEditor(IWidgetSettings settings) {
        super(settings);
    }

    public ComboBoxFieldEditor(String name, String labelText, List<String> tags, Composite parent) {
        this.init(name, labelText);
        if (tags != null) {
            this.tags = tags.toArray(new String[tags.size()]);
        }
        this.createControl(parent);
    }

    protected Combo getComboField() {
        return this.comboField;
    }

    protected Combo getComboControl() {
        return this.comboField;
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.comboField.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelComposite(parent);
        this.comboField = this.getComboControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        if (this.widthInChars != UNLIMITED) {
            GC gc = new GC((Drawable)this.comboField);
            try {
                Point extent = gc.textExtent("X");
                gd.widthHint = this.widthInChars * extent.x;
            }
            finally {
                gc.dispose();
            }
        } else {
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
        }
        this.comboField.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.comboField != null) {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            Object listValue = ComboBoxFieldEditor.mapFromTo(this.listContentProvider.getElements(this), this.getTags(), value);
            this.comboField.setText(listValue.toString());
            this.stringValue = value;
        }
    }

    protected void doLoadDefault() {
        if (this.comboField != null) {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.comboField.setText(value);
        }
        this.valueChanged();
    }

    protected void doStore() {
        Object selectedValue = ComboBoxFieldEditor.mapFromTo(this.getTags(), this.listContentProvider.getElements(this), this.comboField.getText());
        this.getPreferenceStore().setValue(this.getPreferenceName(), selectedValue.toString());
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected Combo getComboControl(Composite parent) {
        if (this.comboField == null) {
            int style = this.getSettings().getStyle("Combo.Style");
            Color bg = this.getSettings().getColor("Combo.Background");
            if (bg == null) {
                bg = Display.getCurrent().getSystemColor(1);
            }
            Color fg = this.getSettings().getColor("Combo.Foreground");
            Font font = this.getSettings().getFont("Combo.Font");
            Border border = null;
            if (!"macosx".equals(Platform.getOS())) {
                border = this.getSettings().getBorder("Combo.Border");
            }
            if (style == -1) {
                style = 2048;
            }
            if (this.isDropDown()) {
                style |= 8;
            }
            if (border != null) {
                BorderedControl borderedControl = new BorderedControl(parent, 0, border);
                this.comboField = new Combo((Composite)borderedControl, style);
                this.comboField.setBackground(bg);
            } else {
                this.comboField = new Combo(parent, style);
            }
            this.comboField.setFont(font);
            this.comboField.setForeground(fg);
            String[] tags = this.getTags();
            this.comboField.setItems(tags);
            if (tags != null && tags.length > 5) {
                int k = tags.length > 10 ? 10 : tags.length;
                this.comboField.setVisibleItemCount(k);
            }
            this.stringValue = this.valueProvider.getStringValue(true).toString();
            this.comboField.setFont(parent.getFont());
            this.keyAdapter = new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    ComboBoxFieldEditor.this.valueChanged();
                }
            };
            this.focusAdapter = new FocusAdapter(){
                boolean isSettingFocus = false;

                public void focusGained(FocusEvent e) {
                    if (this.isSettingFocus) {
                        return;
                    }
                    ComboBoxFieldEditor.this.refreshValidState();
                    this.isSettingFocus = true;
                    try {
                        if (ComboBoxFieldEditor.this.comboField != null && !ComboBoxFieldEditor.this.comboField.isDisposed()) {
                            ComboBoxFieldEditor.this.comboField.setFocus();
                        }
                    }
                    finally {
                        this.isSettingFocus = false;
                    }
                }

                public void focusLost(FocusEvent e) {
                    ComboBoxFieldEditor.this.clearErrorMessage();
                }
            };
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (ComboBoxFieldEditor.this.modifyLock) {
                        return;
                    }
                    ComboBoxFieldEditor.this.modifyLock = true;
                    try {
                        ComboBoxFieldEditor.this.valueChanged();
                    }
                    finally {
                        ComboBoxFieldEditor.this.modifyLock = false;
                    }
                }
            };
            this.disposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ComboBoxFieldEditor.this.comboField = null;
                }
            };
            this.comboField.addKeyListener((KeyListener)this.keyAdapter);
            this.comboField.addFocusListener((FocusListener)this.focusAdapter);
            this.setStringValue(this.stringValue);
            this.comboField.addModifyListener(this.modifyListener);
            this.comboField.addDisposeListener(this.disposeListener);
            if (this.textLimit > 0) {
                this.comboField.setTextLimit(this.textLimit);
            }
            String[] ts = this.getTags();
            TreeSet<String> set = new TreeSet<String>();
            int i = 0;
            while (i < ts.length) {
                set.add(ts[i]);
                ++i;
            }
            if (this.elements != null) {
                i = 0;
                while (i < this.elements.length) {
                    set.add(this.elements[i].toString());
                    ++i;
                }
            }
            SimpleContentProposalProvider cpp = new SimpleContentProposalProvider(set.toArray(new String[0]));
            cpp.setFiltering(true);
            KeyStroke ks = AttributeContentProposalProviderFactory.getCtrlSpaceKeyStroke();
            ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.comboField, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)cpp, ks, null);
            adapter.setPropagateKeys(true);
            adapter.setProposalAcceptanceStyle(2);
        } else {
            this.checkParent((Control)this.comboField, parent);
        }
        return this.comboField;
    }

    protected void valueChanged() {
        if (this.comboField != null && "linux".equals(Platform.getOS())) {
            Point point = this.comboField.getSelection();
            this.comboField.setFocus();
            this.comboField.setSelection(point);
        }
        this.setPresentsDefaultValue(false);
        boolean oldState = this.isValid;
        this.refreshValidState();
        if (this.isValid != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this.isValid);
        }
        String oldValue = this.stringValue;
        int i = this.comboField.getSelectionIndex();
        String newValue = i < 0 ? this.comboField.getText() : this.elements[i].toString();
        this.stringValue = ComboBoxFieldEditor.mapFromTo(this.getTags(), this.listContentProvider.getElements(this), newValue).toString();
        this.valueProvider.removeValueChangeListener(this);
        java.beans.PropertyChangeEvent event = new java.beans.PropertyChangeEvent(this, "IPropertyEditor.value", oldValue, this.stringValue);
        this.valueChangeListener.valueChange(event);
        this.revalidateValue();
        if (this.valueProvider == null) {
            return;
        }
        this.valueProvider.addValueChangeListener(this);
    }

    private void revalidateValue() {
        if (this.valueProvider == null) {
            return;
        }
        Object v = this.valueProvider.getValue();
        if (v == null || !(this.propertyEditor.getInput() instanceof DefaultValueAdapter)) {
            return;
        }
        String s = v.toString();
        String sv = this.stringValue;
        if (((DefaultValueAdapter)this.propertyEditor.getInput()).getAttribute().isTrimmable()) {
            sv = sv.trim();
        }
        if (!s.equals(sv)) {
            this.stringValue = s;
            if (!s.equals(this.comboField.getText())) {
                Point p = this.comboField.getSelection();
                boolean end = p.x == this.comboField.getText().length();
                this.comboField.setText(s);
                if (end) {
                    this.comboField.setSelection(new Point(this.comboField.getText().length(), this.comboField.getText().length()));
                }
            }
        }
    }

    protected String[] getTags() {
        this.elements = this.listContentProvider.getElements(this);
        this.tags = new String[this.elements.length];
        int i = 0;
        while (i < this.elements.length) {
            this.tags[i] = this.labelProvider.getText(this.elements[i]);
            ++i;
        }
        return this.tags;
    }

    protected void setStringValue(String newValue) {
        if (this.modifyLock) {
            return;
        }
        String oldValue = this.stringValue;
        this.stringValue = newValue;
        if (this.comboField != null && !this.isSameValue(newValue)) {
            this.modifyLock = true;
            this.comboField.setText(ComboBoxFieldEditor.mapFromTo(this.elements, this.tags, newValue).toString());
            this.modifyLock = false;
        }
        java.beans.PropertyChangeEvent event = new java.beans.PropertyChangeEvent(this, "IPropertyEditor.value", oldValue, newValue);
        this.valueChangeListener.valueChange(event);
    }

    boolean isSameValue(String newValue) {
        DefaultValueAdapter a;
        if (this.comboField == null || this.comboField.isDisposed() || newValue == null) {
            return false;
        }
        String oldTextValue = this.comboField.getText();
        if (this.propertyEditor != null && this.propertyEditor.getInput() instanceof DefaultValueAdapter && (a = (DefaultValueAdapter)this.propertyEditor.getInput()).getAttribute().isTrimmable()) {
            return oldTextValue != null && oldTextValue.trim().equals(newValue.trim());
        }
        return oldTextValue != null && oldTextValue.equals(newValue);
    }

    private static Object mapFromTo(Object[] from, Object[] to, Object value) {
        if (from == null || from.length == 0 || to == null || to.length == 0) {
            return value;
        }
        int index = Arrays.asList(from).indexOf(value);
        return index == -1 ? value : to[index];
    }

    @Override
    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        if (propertyEditor != null) {
            this.valueProvider = (IValueProvider)propertyEditor.getAdapter(IValueProvider.class);
            this.valueChangeListener = (IValueChangeListener)propertyEditor.getAdapter(IValueChangeListener.class);
            this.labelProvider = (ILabelProvider)propertyEditor.getAdapter(ILabelProvider.class);
            this.listContentProvider = (IListContentProvider)propertyEditor.getAdapter(IListContentProvider.class);
            this.setErrorProvider((IAttributeErrorProvider)propertyEditor.getAdapter(IAttributeErrorProvider.class));
        }
        this.setPropertyChangeListener(this);
        this.valueProvider.addValueChangeListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.comboField != null) {
            this.comboField.removeKeyListener((KeyListener)this.keyAdapter);
            this.comboField.removeFocusListener((FocusListener)this.focusAdapter);
            this.comboField.removeModifyListener(this.modifyListener);
            this.comboField.removeDisposeListener(this.disposeListener);
            this.keyAdapter = null;
            this.focusAdapter = null;
            this.modifyListener = null;
            this.disposeListener = null;
            if (!this.comboField.isDisposed()) {
                this.comboField.dispose();
            }
        }
        this.setPropertyChangeListener(null);
        if (this.valueProvider != null) {
            this.valueProvider.removeValueChangeListener(this);
        }
        this.propertyEditor = null;
        this.valueChangeListener = null;
        this.valueProvider = null;
        this.labelProvider = null;
        this.listContentProvider = null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("field_editor_value".equals(event.getProperty())) {
            this.setPropertyChangeListener(null);
            java.beans.PropertyChangeEvent e = new java.beans.PropertyChangeEvent(this, "IPropertyEditor.value", ComboBoxFieldEditor.mapFromTo(this.tags, this.elements, event.getOldValue()), ComboBoxFieldEditor.mapFromTo(this.tags, this.elements, event.getNewValue()));
            this.valueChangeListener.valueChange(e);
            this.setPropertyChangeListener(this);
        }
    }

    @Override
    public Control[] getControls(Composite parent) {
        return new Control[]{this.getLabelComposite(parent), this.getComboControl(parent)};
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        Object v;
        super.propertyChange(evt);
        if ("IPropertyEditor.value".equals(evt.getPropertyName())) {
            v = evt.getNewValue();
            this.valueProvider.removeValueChangeListener(this);
            this.setStringValue(v == null ? "" : v.toString());
            this.valueProvider.addValueChangeListener(this);
        }
        if ("IPropertyEditor.listContent".equals(evt.getPropertyName())) {
            v = this.comboField.getText();
            this.valueProvider.removeValueChangeListener(this);
            String[] tags = this.getTags();
            this.comboField.setItems(tags);
            this.comboField.setText((String)v);
            int i = this.comboField.getSelectionIndex();
            this.valueProvider.addValueChangeListener(this);
            if (i < 0 && tags != null && tags.length > 0) {
                this.comboField.setText(tags[0]);
            } else if (i < 0) {
                this.comboField.setText("");
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getComboControl() != null) {
            this.getComboControl().setEnabled(enabled);
            if (enabled) {
                Color bg = this.getSettings().getColor("Combo.Background");
                if (bg == null) {
                    bg = Display.getDefault().getSystemColor(1);
                }
            } else {
                Color bg = this.getSettings().getColor("Combo.Background.Disabled");
                if (bg == null) {
                    bg = Display.getDefault().getSystemColor(22);
                }
            }
            this.updateErrorState();
        }
    }

    @Override
    public void cut() {
        if (this.comboField != null && !this.comboField.isDisposed() && this.comboField.isFocusControl()) {
            Text text = this.getInnerText();
            if (text != null) {
                text.cut();
            }
            this.valueChanged();
        }
    }

    @Override
    public void copy() {
        Text text;
        if (this.comboField != null && !this.comboField.isDisposed() && this.comboField.isFocusControl() && (text = this.getInnerText()) != null) {
            text.copy();
        }
    }

    @Override
    public void paste() {
        if (this.comboField != null && !this.comboField.isDisposed() && this.comboField.isFocusControl()) {
            Text text = this.getInnerText();
            if (text != null) {
                text.paste();
            }
            this.valueChanged();
        }
    }

    @Override
    public void delete() {
    }

    private Text getInnerText() {
        try {
            Field f = this.comboField.getClass().getDeclaredField("text");
            f.setAccessible(true);
            Text text = (Text)f.get(this.comboField);
            return text != null && !text.isDisposed() ? text : null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public boolean isDropDown() {
        return this.dropDown;
    }

    public void setDropDown(boolean b) {
        this.dropDown = b;
    }

    public void setFocus() {
        if (this.comboField != null) {
            this.comboField.getParent().setFocus();
            this.comboField.setSelection(new Point(0, this.comboField.getText().length()));
            this.comboField.setFocus();
        }
    }
}

