/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.forms;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.jboss.tools.common.model.ui.forms.DefaultFormContainer;
import org.jboss.tools.common.model.ui.forms.IForm;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.widgets.ScrolledComposite;

public class ScrollableFormContainer
extends DefaultFormContainer {
    public static final int H_SCROLL_INCREMENT = 5;
    public static final int V_SCROLL_INCREMENT = 64;
    private IWidgetSettings settings;
    private ScrolledComposite scrolledComposite;
    private boolean verticalFit = false;
    private boolean scrollable = true;

    public ScrollableFormContainer() {
    }

    public ScrollableFormContainer(IForm form) {
        super(form);
    }

    public void dispose() {
        super.dispose();
        if (this.scrolledComposite != null && !this.scrolledComposite.isDisposed()) {
            this.scrolledComposite.dispose();
        }
        this.scrolledComposite = null;
    }

    public Control createControl(Composite parent, IWidgetSettings settings) {
        this.settings = settings;
        this.scrolledComposite = new ScrolledComposite(parent, 512);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.scrolledComposite.setLayout((Layout)layout);
        if (this.getLayoutData() != null) {
            this.scrolledComposite.setLayoutData(this.getLayoutData());
        }
        return this.scrolledComposite;
    }

    public Control getControl() {
        return this.scrolledComposite;
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public void setScrollable(boolean b) {
        this.scrollable = b;
    }

    public boolean isVerticalFit() {
        return this.verticalFit;
    }

    public void setVerticalFit(boolean b) {
        this.verticalFit = b;
    }

    public void update() {
        super.update();
        if (this.scrolledComposite instanceof ScrolledComposite) {
            this.updateScrolledComposite();
        } else if (this.scrolledComposite != null) {
            this.scrolledComposite.layout(true);
        }
    }

    public void updateScrollBars() {
        if (this.scrolledComposite instanceof ScrolledComposite) {
            this.updateScrolledComposite();
        }
    }

    public void updateScrolledComposite() {
        ScrolledComposite sc = this.scrolledComposite;
        this.getControl();
        if (this.scrolledComposite.getViewport() != null && !this.scrolledComposite.getViewport().isDisposed()) {
            Point oldSize = this.scrolledComposite.getViewport().getSize();
            Point newSize = this.scrolledComposite.getViewport().computeSize(-1, -1);
            if (oldSize != null && oldSize.equals((Object)newSize)) {
                return;
            }
            if (newSize != null && oldSize != null && oldSize.x >= newSize.x && oldSize.y >= newSize.y) {
                return;
            }
            this.scrolledComposite.getViewport().setSize(newSize);
            ScrollableFormContainer.updatePageIncrement(sc);
        }
    }

    public static void updatePageIncrement(ScrolledComposite scomp) {
        ScrollBar vbar = scomp.getVerticalBar();
        if (vbar != null) {
            Rectangle clientArea = scomp.getClientArea();
            int increment = clientArea.height - 5;
            vbar.setPageIncrement(increment);
        }
    }

    public boolean addForm(IForm form) {
        if (this.scrolledComposite != null) {
            Control control = form.getControl();
            if (control == null) {
                control = form.createControl(this.scrolledComposite.getViewport(), this.settings);
            } else {
                control.setParent(this.scrolledComposite.getViewport());
            }
            GridData gd = new GridData(1808);
            control.setLayoutData((Object)gd);
            this.reflow();
        }
        form.setParent(this);
        form.setEnabled(this.isEnabled());
        return this.forms.add(form);
    }

    protected void reflow() {
        this.scrolledComposite.getViewport().setRedraw(false);
        this.scrolledComposite.getViewport().getParent().setRedraw(false);
        this.scrolledComposite.getViewport().layout(true);
        this.scrolledComposite.getViewport().getParent().layout(true);
        this.scrolledComposite.getViewport().setRedraw(true);
        this.scrolledComposite.getViewport().getParent().setRedraw(true);
    }
}

