/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.SQLException;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.Streamable;
import org.teiid.core.util.InputStreamReader;

public class BaseLob
implements Externalizable,
InputStreamFactory.StreamFactoryReference {
    private static final long serialVersionUID = -1586959324208959519L;
    private InputStreamFactory streamFactory;
    private Charset charset;

    public BaseLob() {
    }

    protected BaseLob(InputStreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    @Override
    public void setStreamFactory(InputStreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    public InputStreamFactory getStreamFactory() throws SQLException {
        if (this.streamFactory == null) {
            throw new SQLException("Already freed");
        }
        return this.streamFactory;
    }

    public void setEncoding(String encoding) {
        this.charset = encoding != null ? Charset.forName(encoding) : null;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void free() throws SQLException {
        if (this.streamFactory != null) {
            try {
                this.streamFactory.free();
                this.streamFactory = null;
            }
            catch (IOException e) {
                SQLException ex = new SQLException(e.getMessage());
                ex.initCause(e);
                throw ex;
            }
        }
    }

    public Reader getCharacterStream() throws SQLException {
        try {
            Reader r = this.getStreamFactory().getCharacterStream();
            if (r != null) {
                return r;
            }
        }
        catch (IOException e) {
            SQLException ex = new SQLException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        Charset cs = this.getCharset();
        if (cs == null) {
            cs = Streamable.CHARSET;
        }
        return new InputStreamReader(this.getBinaryStream(), cs.newDecoder());
    }

    public InputStream getBinaryStream() throws SQLException {
        try {
            return this.getStreamFactory().getInputStream();
        }
        catch (IOException e) {
            SQLException ex = new SQLException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.streamFactory = (InputStreamFactory)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.streamFactory);
    }
}

