/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.teiid.client.RequestMessage;
import org.teiid.core.util.SqlUtil;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.DataTypeTransformer;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.PreparedStatementImpl;

public class CallableStatementImpl
extends PreparedStatementImpl
implements CallableStatement {
    private Object parameterValue;

    static CallableStatementImpl newInstance(ConnectionImpl connection, String procedureCall, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new CallableStatementImpl(connection, procedureCall, resultSetType, resultSetConcurrency);
    }

    CallableStatementImpl(ConnectionImpl connection, String procedureCall, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(connection, procedureCall, resultSetType, resultSetConcurrency);
        this.prepareSql = procedureCall;
    }

    @Override
    protected RequestMessage createRequestMessage(String[] commands, boolean isBatchedCommand, RequestMessage.ResultsMode resultsMode) {
        RequestMessage message = super.createRequestMessage(commands, isBatchedCommand, resultsMode);
        message.setStatementType(RequestMessage.StatementType.CALLABLE);
        return message;
    }

    @Override
    public void close() throws SQLException {
        this.prepareSql = null;
        super.close();
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        BigDecimal bigDecimalParam = DataTypeTransformer.getBigDecimal(this.getObject(parameterIndex));
        return bigDecimalParam.setScale(scale);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getBigDecimal(this.getObject(parameterIndex));
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getBlob(this.getObject(parameterIndex));
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getBoolean(this.getObject(parameterIndex));
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getByte(this.getObject(parameterIndex));
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getClob(this.getObject(parameterIndex));
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        return this.getDate(parameterIndex, null);
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        Date value = DataTypeTransformer.getDate(this.getObject(parameterIndex));
        if (value == null) {
            return null;
        }
        if (cal != null) {
            value = TimestampWithTimezone.createDate(value, this.getDefaultCalendar().getTimeZone(), cal);
        }
        return value;
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getDouble(this.getObject(parameterIndex));
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getFloat(this.getObject(parameterIndex));
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getInteger(this.getObject(parameterIndex));
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getLong(this.getObject(parameterIndex));
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        Object indexInResults = this.outParamIndexMap.get(new Integer(parameterIndex));
        if (indexInResults == null) {
            throw new IllegalArgumentException(JDBCPlugin.Util.getString("MMCallableStatement.Param_not_found", parameterIndex));
        }
        this.checkStatement();
        this.parameterValue = this.resultSet.getOutputParamValue((Integer)indexInResults);
        return this.parameterValue;
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getShort(this.getObject(parameterIndex));
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        return this.getObject(parameterIndex).toString();
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        return this.getTime(parameterIndex, null);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        Time value = DataTypeTransformer.getTime(this.getObject(parameterIndex));
        if (value == null) {
            return null;
        }
        if (cal != null) {
            value = TimestampWithTimezone.createTime(value, this.getDefaultCalendar().getTimeZone(), cal);
        }
        return value;
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.getTimestamp(parameterIndex, null);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        Timestamp value = DataTypeTransformer.getTimestamp(this.getObject(parameterIndex));
        if (value == null) {
            return null;
        }
        if (cal != null) {
            value = TimestampWithTimezone.createTimestamp(value, this.getDefaultCalendar().getTimeZone(), cal);
        }
        return value;
    }

    @Override
    public void registerOutParameter(int parameterIndex, int jdbcSqlType) throws SQLException {
    }

    @Override
    public void registerOutParameter(int parameterIndex, int jdbcSqlType, int scale) throws SQLException {
    }

    @Override
    public void registerOutParameter(int parameterIndex, int jdbcSqlType, String typeName) throws SQLException {
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkStatement();
        return this.parameterValue == null;
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getSQLXML(this.getObject(parameterIndex));
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getBytes(this.getObject(parameterIndex));
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getCharacterStream(this.getObject(parameterIndex));
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }
}

