/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.WrapperImpl;

public class FilteredResultsMetadata
extends WrapperImpl
implements ResultSetMetaData {
    private ResultSetMetaData delegate;
    private int actualColumnCount;

    static FilteredResultsMetadata newInstance(ResultSetMetaData rsmd, int actualColumnCount) {
        return new FilteredResultsMetadata(rsmd, actualColumnCount);
    }

    FilteredResultsMetadata(ResultSetMetaData rsmd, int actualColumnCount) {
        this.delegate = rsmd;
        this.actualColumnCount = actualColumnCount;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.actualColumnCount;
    }

    private void verifyColumnIndex(int index) throws SQLException {
        if (index > this.actualColumnCount) {
            throw new SQLException(JDBCPlugin.Util.getString("FilteredResultsMetadata.Invalid_index", index));
        }
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isAutoIncrement(column);
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isCaseSensitive(column);
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isSearchable(column);
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isCurrency(column);
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isNullable(column);
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isSigned(column);
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getColumnDisplaySize(column);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getColumnLabel(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getColumnName(column);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getSchemaName(column);
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getPrecision(column);
    }

    @Override
    public int getScale(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getScale(column);
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getTableName(column);
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getCatalogName(column);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getColumnType(column);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getColumnTypeName(column);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isReadOnly(column);
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isWritable(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isDefinitelyWritable(column);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getColumnClassName(column);
    }
}

