/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.ant.internal.launching.launchConfigurations.AntLaunchDelegate;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBufferManager;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.manipulation.FileBufferOperationRunner;
import org.eclipse.core.filebuffers.manipulation.IFileBufferOperation;
import org.eclipse.core.filebuffers.manipulation.MultiTextEditWithProgress;
import org.eclipse.core.filebuffers.manipulation.TextFileBufferOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.TextEdit;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.OverrideRepository;
import org.hibernate.cfg.reveng.ReverseEngineeringSettings;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.model.impl.ExporterFactory;
import org.hibernate.eclipse.launch.CodeGenXMLFactory;
import org.hibernate.eclipse.launch.CodeGenerationProcessListener;
import org.hibernate.eclipse.launch.CodeGenerationUtils;
import org.hibernate.eclipse.launch.ExporterAttributes;
import org.hibernate.eclipse.launch.PathHelper;
import org.hibernate.tool.hbm2x.ArtifactCollector;
import org.hibernate.tool.hbm2x.Exporter;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenerationLaunchDelegate
extends AntLaunchDelegate {
    protected IPath path2GenBuildXml = null;

    protected void createFile(String fileName, String fileContent) throws IOException {
        FileOutputStream fos = null;
        try {
            File ff = new File(fileName);
            if (!ff.exists()) {
                ff.createNewFile();
            }
            fos = new FileOutputStream(fileName);
            fos.write(fileContent.getBytes());
            fos.flush();
        }
        catch (Throwable throwable) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void createBuildXmlFile(ILaunchConfiguration lc, String fileName) throws UnsupportedEncodingException, IOException {
        CodeGenXMLFactory codeGenXMLFactory = new CodeGenXMLFactory(lc);
        String externalPropFileName = CodeGenXMLFactory.getExternalPropFileNameStandard(fileName);
        codeGenXMLFactory.setExternalPropFileName(externalPropFileName);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null && workspace.getRoot() != null && workspace.getRoot().getLocation() != null) {
            codeGenXMLFactory.setWorkspacePath(workspace.getRoot().getLocation().toString());
        }
        String buildXml = codeGenXMLFactory.createCodeGenXML();
        this.createFile(fileName, buildXml);
        String propFileContentPreSave = codeGenXMLFactory.getPropFileContentPreSave();
        this.createFile(externalPropFileName, propFileContentPreSave);
    }

    public ILaunchConfiguration updateLaunchConfig(ILaunchConfiguration lc) throws CoreException {
        ILaunchConfigurationWorkingCopy lcwc = lc.getWorkingCopy();
        String fileName = null;
        try {
            fileName = this.getPath2GenBuildXml().toString();
        }
        catch (IOException e) {
            throw new CoreException(HibernateConsolePlugin.throwableToStatus(e, 666));
        }
        lcwc.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", fileName);
        lcwc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.eclipse.ant.internal.launching.remote.InternalAntRunner");
        lcwc.setAttribute("process_factory_id", "org.eclipse.ant.ui.remoteAntProcessFactory");
        throw new IllegalStateException("'Run in External Process' is not fully implemented. Please do not use it");
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)configuration);
        Assert.isNotNull((Object)monitor);
        ExporterAttributes attributes = new ExporterAttributes(configuration);
        List<ExporterFactory> exporterFactories = attributes.getExporterFactories();
        Iterator<ExporterFactory> iter = exporterFactories.iterator();
        while (iter.hasNext()) {
            ExporterFactory exFactory = iter.next();
            if (exFactory.isEnabled(configuration)) continue;
            iter.remove();
        }
        if (attributes.isUseExternalProcess()) {
            String fileName = null;
            try {
                fileName = this.getPath2GenBuildXml().toString();
                this.createBuildXmlFile(configuration, fileName);
            }
            catch (UnsupportedEncodingException e) {
                throw new CoreException(HibernateConsolePlugin.throwableToStatus(e, 666));
            }
            catch (IOException e) {
                throw new CoreException(HibernateConsolePlugin.throwableToStatus(e, 666));
            }
            configuration = this.updateLaunchConfig(configuration);
            super.launch(configuration, mode, launch, monitor);
            Properties props = new Properties();
            props.put("ejb3", "" + attributes.isEJB3Enabled());
            props.put("jdk5", "" + attributes.isJDK5Enabled());
            HashSet<String> outputDirs = new HashSet<String>();
            for (ExporterFactory exFactory : exporterFactories) {
                exFactory.collectOutputDirectories(attributes.getOutputPath(), props, outputDirs);
            }
            IProcess[] processes = launch.getProcesses();
            CodeGenerationProcessListener refresher = new CodeGenerationProcessListener(processes[0], fileName, outputDirs);
            refresher.startBackgroundRefresh();
            return;
        }
        try {
            try {
                HashSet<String> outputDirectories = new HashSet<String>();
                ExporterFactory[] exporters = exporterFactories.toArray(new ExporterFactory[exporterFactories.size()]);
                ArtifactCollector collector = this.runExporters(attributes, exporters, outputDirectories, monitor);
                for (String path : outputDirectories) {
                    CodeGenerationUtils.refreshOutputDir(path);
                }
                RefreshTab.refreshResources((ILaunchConfiguration)configuration, (IProgressMonitor)monitor);
                if (collector != null) {
                    this.formatGeneratedCode(monitor, collector);
                }
            }
            catch (Exception e) {
                throw new CoreException(HibernateConsolePlugin.throwableToStatus(e, 666));
            }
            catch (NoClassDefFoundError e) {
                throw new CoreException(HibernateConsolePlugin.throwableToStatus((Throwable)new HibernateConsoleRuntimeException(HibernateConsoleMessages.CodeGenerationLaunchDelegate_received_noclassdeffounderror, (Throwable)e), 666));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void formatGeneratedCode(IProgressMonitor monitor, ArtifactCollector collector) {
        FormatGeneratedCode operation = new FormatGeneratedCode(HibernateConsoleMessages.CodeGenerationLaunchDelegate_formate_generated_code);
        File[] javaFiles = collector.getFiles("java");
        if (javaFiles.length > 0) {
            IPath[] locations = new IPath[javaFiles.length];
            int i = 0;
            while (i < javaFiles.length) {
                File file = javaFiles[i];
                locations[i] = new Path(file.getPath());
                ++i;
            }
            FileBufferOperationRunner runner = new FileBufferOperationRunner((IFileBufferManager)FileBuffers.getTextFileBufferManager(), (Object)HibernateConsolePlugin.getShell());
            try {
                runner.execute(locations, (IFileBufferOperation)operation, monitor);
            }
            catch (OperationCanceledException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.CodeGenerationLaunchDelegate_java_format_cancelled, e);
            }
            catch (CoreException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.CodeGenerationLaunchDelegate_exception_during_java_format, e);
            }
            catch (Throwable e) {
                HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.CodeGenerationLaunchDelegate_exception_during_java_format, e);
            }
        }
    }

    private ArtifactCollector runExporters(final ExporterAttributes attributes, final ExporterFactory[] exporterFactories, final Set<String> outputDirectories, final IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.valueOf(HibernateConsoleMessages.CodeGenerationLaunchDelegate_generating_code_for) + attributes.getConsoleConfigurationName(), exporterFactories.length + 1);
        if (monitor.isCanceled()) {
            return null;
        }
        ConsoleConfiguration cc = KnownConfigurations.getInstance().find(attributes.getConsoleConfigurationName());
        if (attributes.isReverseEngineer()) {
            monitor.subTask(HibernateConsoleMessages.CodeGenerationLaunchDelegate_reading_jdbc_metadata);
        }
        final Configuration cfg = this.buildConfiguration(attributes, cc, ResourcesPlugin.getWorkspace().getRoot());
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return null;
        }
        return (ArtifactCollector)cc.execute(new ExecutionContext.Command(){

            public Object execute() {
                ArtifactCollector artifactCollector = new ArtifactCollector();
                Properties props = new Properties();
                props.put("ejb3", "" + attributes.isEJB3Enabled());
                props.put("jdk5", "" + attributes.isJDK5Enabled());
                int i = 0;
                while (i < exporterFactories.length) {
                    Exporter exporter;
                    monitor.subTask(exporterFactories[i].getExporterDefinition().getDescription());
                    Properties globalProperties = new Properties();
                    globalProperties.putAll((Map<?, ?>)props);
                    try {
                        exporter = exporterFactories[i].createConfiguredExporter(cfg, attributes.getOutputPath(), attributes.getTemplatePath(), globalProperties, outputDirectories, artifactCollector);
                    }
                    catch (CoreException e) {
                        throw new HibernateConsoleRuntimeException(String.valueOf(HibernateConsoleMessages.CodeGenerationLaunchDelegate_error_while_setting_up) + exporterFactories[i].getExporterDefinition(), (Throwable)e);
                    }
                    try {
                        exporter.start();
                    }
                    catch (HibernateException he) {
                        throw new HibernateConsoleRuntimeException(String.valueOf(HibernateConsoleMessages.CodeGenerationLaunchDelegate_error_while_running) + exporterFactories[i].getExporterDefinition().getDescription(), (Throwable)he);
                    }
                    monitor.worked(1);
                    ++i;
                }
                return artifactCollector;
            }
        });
    }

    private Configuration buildConfiguration(final ExporterAttributes attributes, ConsoleConfiguration cc, IWorkspaceRoot root) {
        boolean reveng = attributes.isReverseEngineer();
        final String reverseEngineeringStrategy = attributes.getRevengStrategy();
        boolean preferBasicCompositeids = attributes.isPreferBasicCompositeIds();
        final IResource revengres = PathHelper.findMember(root, attributes.getRevengSettings());
        if (reveng) {
            Configuration configuration = null;
            configuration = cc.hasConfiguration() ? cc.getConfiguration() : cc.buildWith(null, false);
            final JDBCMetaDataConfiguration cfg = new JDBCMetaDataConfiguration();
            Properties properties = configuration.getProperties();
            cfg.setProperties(properties);
            cc.buildWith((Configuration)cfg, false);
            cfg.setPreferBasicCompositeIds(preferBasicCompositeids);
            cc.execute(new ExecutionContext.Command(){

                public Object execute() {
                    DefaultReverseEngineeringStrategy res = new DefaultReverseEngineeringStrategy();
                    OverrideRepository repository = null;
                    if (revengres != null) {
                        File file = PathHelper.getLocation(revengres).toFile();
                        repository = new OverrideRepository();
                        repository.addFile(file);
                    }
                    if (repository != null) {
                        res = repository.getReverseEngineeringStrategy((ReverseEngineeringStrategy)res);
                    }
                    if (reverseEngineeringStrategy != null && reverseEngineeringStrategy.trim().length() > 0) {
                        res = CodeGenerationLaunchDelegate.this.loadreverseEngineeringStrategy(reverseEngineeringStrategy, (ReverseEngineeringStrategy)res);
                    }
                    ReverseEngineeringSettings qqsettings = new ReverseEngineeringSettings((ReverseEngineeringStrategy)res).setDefaultPackageName(attributes.getPackageName()).setDetectManyToMany(attributes.detectManyToMany()).setDetectOneToOne(attributes.detectOneToOne()).setDetectOptimisticLock(attributes.detectOptimisticLock());
                    res.setSettings(qqsettings);
                    cfg.setReverseEngineeringStrategy((ReverseEngineeringStrategy)res);
                    cfg.readFromJDBC();
                    cfg.buildMappings();
                    return null;
                }
            });
            return cfg;
        }
        cc.build();
        final Configuration configuration = cc.getConfiguration();
        cc.execute(new ExecutionContext.Command(){

            public Object execute() {
                configuration.buildMappings();
                return configuration;
            }
        });
        return configuration;
    }

    private ReverseEngineeringStrategy loadreverseEngineeringStrategy(String className, ReverseEngineeringStrategy delegate) {
        try {
            Class clazz = ReflectHelper.classForName((String)className);
            Constructor constructor = clazz.getConstructor(ReverseEngineeringStrategy.class);
            return (ReverseEngineeringStrategy)constructor.newInstance(delegate);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Class clazz = ReflectHelper.classForName((String)className);
                ReverseEngineeringStrategy rev = (ReverseEngineeringStrategy)clazz.newInstance();
                return rev;
            }
            catch (Exception eq) {
                String out = NLS.bind((String)HibernateConsoleMessages.CodeGenerationLaunchDelegate_could_not_create_or_find_with_default_noarg_constructor, (Object)className);
                throw new HibernateConsoleRuntimeException(out, (Throwable)eq);
            }
        }
        catch (Exception e) {
            String out = NLS.bind((String)HibernateConsoleMessages.CodeGenerationLaunchDelegate_could_not_create_or_find_with_one_argument_delegate_constructor, (Object)className);
            throw new HibernateConsoleRuntimeException(out, (Throwable)e);
        }
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        ExporterAttributes attributes = new ExporterAttributes(configuration);
        String configName = attributes.getConsoleConfigurationName();
        if (StringHelper.isEmpty((String)configName)) {
            this.abort(String.valueOf(HibernateConsoleMessages.CodeGenerationLaunchDelegate_console_configuration_name_is_empty_in) + configuration.getName(), null, 1000);
        }
        if (KnownConfigurations.getInstance().find(configName) == null) {
            String out = NLS.bind((String)HibernateConsoleMessages.CodeGenerationLaunchDelegate_console_configuration_not_found_in, (Object)configName, (Object)configuration.getName());
            this.abort(out, null, 1001);
        }
        if (StringHelper.isEmpty((String)attributes.getOutputPath())) {
            this.abort(String.valueOf(HibernateConsoleMessages.CodeGenerationLaunchDelegate_output_has_to_be_specified_in) + configuration.getName(), null, 1002);
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.hibernate.eclipse.console", code, message, exception));
    }

    public IPath getPath2GenBuildXml() throws IOException {
        if (this.path2GenBuildXml != null) {
            return this.path2GenBuildXml;
        }
        this.path2GenBuildXml = new Path(File.createTempFile("build_", "xml").getAbsolutePath());
        return this.path2GenBuildXml;
    }

    private static final class FormatGeneratedCode
    extends TextFileBufferOperation {
        private FormatGeneratedCode(String name) {
            super(name);
        }

        protected DocumentRewriteSessionType getDocumentRewriteSessionType() {
            return DocumentRewriteSessionType.SEQUENTIAL;
        }

        protected MultiTextEditWithProgress computeTextEdit(ITextFileBuffer textFileBuffer, IProgressMonitor progressMonitor) throws CoreException, OperationCanceledException {
            IResource bufferRes = ResourcesPlugin.getWorkspace().getRoot().findMember(textFileBuffer.getLocation());
            Map options = null;
            if (bufferRes != null) {
                IJavaProject project = JavaCore.create((IProject)bufferRes.getProject());
                options = project.getOptions(true);
            }
            CodeFormatter codeFormatter = ToolFactory.createCodeFormatter(options);
            IDocument document = textFileBuffer.getDocument();
            String string = document.get();
            TextEdit edit = codeFormatter.format(8, string, 0, string.length(), 0, null);
            MultiTextEditWithProgress multiTextEditWithProgress = new MultiTextEditWithProgress(this.getOperationName());
            if (edit != null) {
                multiTextEditWithProgress.addChild(edit);
            }
            return multiTextEditWithProgress;
        }
    }
}

