/*
 * JBoss, Home of Professional Open Source.
 *
 * See the LEGAL.txt file distributed with this work for information regarding copyright ownership and licensing.
 *
 * See the AUTHORS.txt file distributed with this work for a full listing of individual contributors.
 */
package com.metamatrix.metamodels.wsdl.impl;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import com.metamatrix.metamodels.wsdl.Definitions;
import com.metamatrix.metamodels.wsdl.Documentation;
import com.metamatrix.metamodels.wsdl.Documented;
import com.metamatrix.metamodels.wsdl.Element;
import com.metamatrix.metamodels.wsdl.ElementOwner;
import com.metamatrix.metamodels.wsdl.ExtensibleDocumented;
import com.metamatrix.metamodels.wsdl.Message;
import com.metamatrix.metamodels.wsdl.MessagePart;
import com.metamatrix.metamodels.wsdl.NamespaceDeclaration;
import com.metamatrix.metamodels.wsdl.NamespaceDeclarationOwner;
import com.metamatrix.metamodels.wsdl.WsdlPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Message</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link com.metamatrix.metamodels.wsdl.impl.MessageImpl#getName <em>Name</em>}</li>
 * <li>{@link com.metamatrix.metamodels.wsdl.impl.MessageImpl#getDocumentation <em>Documentation</em>}</li>
 * <li>{@link com.metamatrix.metamodels.wsdl.impl.MessageImpl#getDeclaredNamespaces <em>Declared Namespaces</em>}</li>
 * <li>{@link com.metamatrix.metamodels.wsdl.impl.MessageImpl#getElements <em>Elements</em>}</li>
 * <li>{@link com.metamatrix.metamodels.wsdl.impl.MessageImpl#getDefinitions <em>Definitions</em>}</li>
 * <li>{@link com.metamatrix.metamodels.wsdl.impl.MessageImpl#getParts <em>Parts</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class MessageImpl extends EObjectImpl implements Message {

    /**
     * The default value of the '{@link #getName() <em>Name</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #getName()
     * @generated
     * @ordered
     */
    protected static final String NAME_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getName() <em>Name</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #getName()
     * @generated
     * @ordered
     */
    protected String name = NAME_EDEFAULT;

    /**
     * The cached value of the '{@link #getDocumentation() <em>Documentation</em>}' containment reference. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @see #getDocumentation()
     * @generated
     * @ordered
     */
    protected Documentation documentation = null;

    /**
     * The cached value of the '{@link #getDeclaredNamespaces() <em>Declared Namespaces</em>}' containment reference list. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #getDeclaredNamespaces()
     * @generated
     * @ordered
     */
    protected EList declaredNamespaces = null;

    /**
     * The cached value of the '{@link #getElements() <em>Elements</em>}' containment reference list. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @see #getElements()
     * @generated
     * @ordered
     */
    protected EList elements = null;

    /**
     * The cached value of the '{@link #getParts() <em>Parts</em>}' containment reference list. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @see #getParts()
     * @generated
     * @ordered
     */
    protected EList parts = null;

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected MessageImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    protected EClass eStaticClass() {
        return WsdlPackage.eINSTANCE.getMessage();
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public String getName() {
        return name;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public void setName( String newName ) {
        String oldName = name;
        name = newName;
        if (eNotificationRequired()) eNotify(new ENotificationImpl(this, Notification.SET, WsdlPackage.MESSAGE__NAME, oldName,
                                                                   name));
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public Documentation getDocumentation() {
        return documentation;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public NotificationChain basicSetDocumentation( Documentation newDocumentation,
                                                    NotificationChain msgs ) {
        Documentation oldDocumentation = documentation;
        documentation = newDocumentation;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, WsdlPackage.MESSAGE__DOCUMENTATION,
                                                                   oldDocumentation, newDocumentation);
            if (msgs == null) msgs = notification;
            else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public void setDocumentation( Documentation newDocumentation ) {
        if (newDocumentation != documentation) {
            NotificationChain msgs = null;
            if (documentation != null) msgs = ((InternalEObject)documentation).eInverseRemove(this,
                                                                                              WsdlPackage.DOCUMENTATION__DOCUMENTED,
                                                                                              Documentation.class,
                                                                                              msgs);
            if (newDocumentation != null) msgs = ((InternalEObject)newDocumentation).eInverseAdd(this,
                                                                                                 WsdlPackage.DOCUMENTATION__DOCUMENTED,
                                                                                                 Documentation.class,
                                                                                                 msgs);
            msgs = basicSetDocumentation(newDocumentation, msgs);
            if (msgs != null) msgs.dispatch();
        } else if (eNotificationRequired()) eNotify(new ENotificationImpl(this, Notification.SET,
                                                                          WsdlPackage.MESSAGE__DOCUMENTATION, newDocumentation,
                                                                          newDocumentation));
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public EList getDeclaredNamespaces() {
        if (declaredNamespaces == null) {
            declaredNamespaces = new EObjectContainmentWithInverseEList(NamespaceDeclaration.class, this,
                                                                        WsdlPackage.MESSAGE__DECLARED_NAMESPACES,
                                                                        WsdlPackage.NAMESPACE_DECLARATION__OWNER);
        }
        return declaredNamespaces;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public EList getElements() {
        if (elements == null) {
            elements = new EObjectContainmentWithInverseEList(Element.class, this, WsdlPackage.MESSAGE__ELEMENTS,
                                                              WsdlPackage.ELEMENT__ELEMENT_OWNER);
        }
        return elements;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public Definitions getDefinitions() {
        if (eContainerFeatureID != WsdlPackage.MESSAGE__DEFINITIONS) return null;
        return (Definitions)eContainer;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public void setDefinitions( Definitions newDefinitions ) {
        if (newDefinitions != eContainer || (eContainerFeatureID != WsdlPackage.MESSAGE__DEFINITIONS && newDefinitions != null)) {
            if (EcoreUtil.isAncestor(this, newDefinitions)) throw new IllegalArgumentException(
                                                                                               "Recursive containment not allowed for " + toString()); //$NON-NLS-1$
            NotificationChain msgs = null;
            if (eContainer != null) msgs = eBasicRemoveFromContainer(msgs);
            if (newDefinitions != null) msgs = ((InternalEObject)newDefinitions).eInverseAdd(this,
                                                                                             WsdlPackage.DEFINITIONS__MESSAGES,
                                                                                             Definitions.class,
                                                                                             msgs);
            msgs = eBasicSetContainer((InternalEObject)newDefinitions, WsdlPackage.MESSAGE__DEFINITIONS, msgs);
            if (msgs != null) msgs.dispatch();
        } else if (eNotificationRequired()) eNotify(new ENotificationImpl(this, Notification.SET,
                                                                          WsdlPackage.MESSAGE__DEFINITIONS, newDefinitions,
                                                                          newDefinitions));
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public EList getParts() {
        if (parts == null) {
            parts = new EObjectContainmentWithInverseEList(MessagePart.class, this, WsdlPackage.MESSAGE__PARTS,
                                                           WsdlPackage.MESSAGE_PART__MESSAGE);
        }
        return parts;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public boolean isNameValid() {
        // TODO: implement this method
        // Ensure that you remove @generated or mark it @generated NOT
        throw new UnsupportedOperationException();
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public IStatus isValid() {
        // TODO: implement this method
        // Ensure that you remove @generated or mark it @generated NOT
        throw new UnsupportedOperationException();
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public NotificationChain eInverseAdd( InternalEObject otherEnd,
                                          int featureID,
                                          Class baseClass,
                                          NotificationChain msgs ) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case WsdlPackage.MESSAGE__DOCUMENTATION:
                    if (documentation != null) msgs = ((InternalEObject)documentation).eInverseRemove(this,
                                                                                                      EOPPOSITE_FEATURE_BASE
                                                                                                      - WsdlPackage.MESSAGE__DOCUMENTATION,
                                                                                                      null,
                                                                                                      msgs);
                    return basicSetDocumentation((Documentation)otherEnd, msgs);
                case WsdlPackage.MESSAGE__DECLARED_NAMESPACES:
                    return ((InternalEList)getDeclaredNamespaces()).basicAdd(otherEnd, msgs);
                case WsdlPackage.MESSAGE__ELEMENTS:
                    return ((InternalEList)getElements()).basicAdd(otherEnd, msgs);
                case WsdlPackage.MESSAGE__DEFINITIONS:
                    if (eContainer != null) msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, WsdlPackage.MESSAGE__DEFINITIONS, msgs);
                case WsdlPackage.MESSAGE__PARTS:
                    return ((InternalEList)getParts()).basicAdd(otherEnd, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null) msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove( InternalEObject otherEnd,
                                             int featureID,
                                             Class baseClass,
                                             NotificationChain msgs ) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case WsdlPackage.MESSAGE__DOCUMENTATION:
                    return basicSetDocumentation(null, msgs);
                case WsdlPackage.MESSAGE__DECLARED_NAMESPACES:
                    return ((InternalEList)getDeclaredNamespaces()).basicRemove(otherEnd, msgs);
                case WsdlPackage.MESSAGE__ELEMENTS:
                    return ((InternalEList)getElements()).basicRemove(otherEnd, msgs);
                case WsdlPackage.MESSAGE__DEFINITIONS:
                    return eBasicSetContainer(null, WsdlPackage.MESSAGE__DEFINITIONS, msgs);
                case WsdlPackage.MESSAGE__PARTS:
                    return ((InternalEList)getParts()).basicRemove(otherEnd, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public NotificationChain eBasicRemoveFromContainer( NotificationChain msgs ) {
        if (eContainerFeatureID >= 0) {
            switch (eContainerFeatureID) {
                case WsdlPackage.MESSAGE__DEFINITIONS:
                    return eContainer.eInverseRemove(this, WsdlPackage.DEFINITIONS__MESSAGES, Definitions.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return eContainer.eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Object eGet( EStructuralFeature eFeature,
                        boolean resolve ) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case WsdlPackage.MESSAGE__NAME:
                return getName();
            case WsdlPackage.MESSAGE__DOCUMENTATION:
                return getDocumentation();
            case WsdlPackage.MESSAGE__DECLARED_NAMESPACES:
                return getDeclaredNamespaces();
            case WsdlPackage.MESSAGE__ELEMENTS:
                return getElements();
            case WsdlPackage.MESSAGE__DEFINITIONS:
                return getDefinitions();
            case WsdlPackage.MESSAGE__PARTS:
                return getParts();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void eSet( EStructuralFeature eFeature,
                      Object newValue ) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case WsdlPackage.MESSAGE__NAME:
                setName((String)newValue);
                return;
            case WsdlPackage.MESSAGE__DOCUMENTATION:
                setDocumentation((Documentation)newValue);
                return;
            case WsdlPackage.MESSAGE__DECLARED_NAMESPACES:
                getDeclaredNamespaces().clear();
                getDeclaredNamespaces().addAll((Collection)newValue);
                return;
            case WsdlPackage.MESSAGE__ELEMENTS:
                getElements().clear();
                getElements().addAll((Collection)newValue);
                return;
            case WsdlPackage.MESSAGE__DEFINITIONS:
                setDefinitions((Definitions)newValue);
                return;
            case WsdlPackage.MESSAGE__PARTS:
                getParts().clear();
                getParts().addAll((Collection)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void eUnset( EStructuralFeature eFeature ) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case WsdlPackage.MESSAGE__NAME:
                setName(NAME_EDEFAULT);
                return;
            case WsdlPackage.MESSAGE__DOCUMENTATION:
                setDocumentation((Documentation)null);
                return;
            case WsdlPackage.MESSAGE__DECLARED_NAMESPACES:
                getDeclaredNamespaces().clear();
                return;
            case WsdlPackage.MESSAGE__ELEMENTS:
                getElements().clear();
                return;
            case WsdlPackage.MESSAGE__DEFINITIONS:
                setDefinitions((Definitions)null);
                return;
            case WsdlPackage.MESSAGE__PARTS:
                getParts().clear();
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public boolean eIsSet( EStructuralFeature eFeature ) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case WsdlPackage.MESSAGE__NAME:
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case WsdlPackage.MESSAGE__DOCUMENTATION:
                return documentation != null;
            case WsdlPackage.MESSAGE__DECLARED_NAMESPACES:
                return declaredNamespaces != null && !declaredNamespaces.isEmpty();
            case WsdlPackage.MESSAGE__ELEMENTS:
                return elements != null && !elements.isEmpty();
            case WsdlPackage.MESSAGE__DEFINITIONS:
                return getDefinitions() != null;
            case WsdlPackage.MESSAGE__PARTS:
                return parts != null && !parts.isEmpty();
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public int eBaseStructuralFeatureID( int derivedFeatureID,
                                         Class baseClass ) {
        if (baseClass == Documented.class) {
            switch (derivedFeatureID) {
                case WsdlPackage.MESSAGE__DOCUMENTATION:
                    return WsdlPackage.DOCUMENTED__DOCUMENTATION;
                default:
                    return -1;
            }
        }
        if (baseClass == NamespaceDeclarationOwner.class) {
            switch (derivedFeatureID) {
                case WsdlPackage.MESSAGE__DECLARED_NAMESPACES:
                    return WsdlPackage.NAMESPACE_DECLARATION_OWNER__DECLARED_NAMESPACES;
                default:
                    return -1;
            }
        }
        if (baseClass == ElementOwner.class) {
            switch (derivedFeatureID) {
                case WsdlPackage.MESSAGE__ELEMENTS:
                    return WsdlPackage.ELEMENT_OWNER__ELEMENTS;
                default:
                    return -1;
            }
        }
        if (baseClass == ExtensibleDocumented.class) {
            switch (derivedFeatureID) {
                default:
                    return -1;
            }
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public int eDerivedStructuralFeatureID( int baseFeatureID,
                                            Class baseClass ) {
        if (baseClass == Documented.class) {
            switch (baseFeatureID) {
                case WsdlPackage.DOCUMENTED__DOCUMENTATION:
                    return WsdlPackage.MESSAGE__DOCUMENTATION;
                default:
                    return -1;
            }
        }
        if (baseClass == NamespaceDeclarationOwner.class) {
            switch (baseFeatureID) {
                case WsdlPackage.NAMESPACE_DECLARATION_OWNER__DECLARED_NAMESPACES:
                    return WsdlPackage.MESSAGE__DECLARED_NAMESPACES;
                default:
                    return -1;
            }
        }
        if (baseClass == ElementOwner.class) {
            switch (baseFeatureID) {
                case WsdlPackage.ELEMENT_OWNER__ELEMENTS:
                    return WsdlPackage.MESSAGE__ELEMENTS;
                default:
                    return -1;
            }
        }
        if (baseClass == ExtensibleDocumented.class) {
            switch (baseFeatureID) {
                default:
                    return -1;
            }
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: "); //$NON-NLS-1$
        result.append(name);
        result.append(')');
        return result.toString();
    }

} // MessageImpl
