/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.builder;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.builder.FindBugsWorker;
import de.tobject.findbugs.builder.ResourceUtils;
import de.tobject.findbugs.builder.WorkItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsBuilder
extends IncrementalProjectBuilder {
    public static boolean DEBUG;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        monitor.subTask("Running FindBugs...");
        switch (kind) {
            case 6: {
                if (!FindbugsPlugin.getUserPreferences(this.getProject()).isRunAtFullBuild()) break;
                if (DEBUG) {
                    System.out.println("FULL BUILD");
                }
                this.doBuild(args, monitor, kind);
                break;
            }
            case 10: {
                if (DEBUG) {
                    System.out.println("INCREMENTAL BUILD");
                }
                this.doBuild(args, monitor, kind);
                break;
            }
            case 9: {
                if (DEBUG) {
                    System.out.println("AUTO BUILD");
                }
                this.doBuild(args, monitor, kind);
            }
        }
        return null;
    }

    private void doBuild(Map<?, ?> args, IProgressMonitor monitor, int kind) throws CoreException {
        List<WorkItem> files;
        boolean incremental = kind != 6;
        IProject project = this.getProject();
        FindBugsWorker worker = new FindBugsWorker(project, monitor);
        if (incremental) {
            IResourceDelta resourceDelta = this.getDelta(project);
            boolean configChanged = !this.isConfigUnchanged(resourceDelta);
            boolean fullBuildEnabled = FindbugsPlugin.getUserPreferences(this.getProject(), configChanged).isRunAtFullBuild();
            if (configChanged && fullBuildEnabled) {
                files = new ArrayList();
                files.add(new WorkItem((IResource)project));
            } else {
                files = ResourceUtils.collectIncremental(resourceDelta);
                if (files.size() > 1) {
                    if (DEBUG) {
                        FindbugsPlugin.getDefault().logInfo("Incremental builder: too many resources to analyse for project " + project + ", files: " + files);
                    }
                    return;
                }
            }
        } else {
            files = new ArrayList<WorkItem>();
            files.add(new WorkItem((IResource)project));
        }
        worker.work(files);
    }

    private boolean isConfigUnchanged(IResourceDelta resourceDelta) {
        return resourceDelta != null && resourceDelta.findMember((IPath)new Path(".project")) == null && resourceDelta.findMember((IPath)new Path(".classpath")) == null && resourceDelta.findMember((IPath)new Path(".fbprefs")) == null;
    }
}

