/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.config.CommandLine;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class Churn {
    BugCollection bugCollection;
    int fixRate = -1;
    Map<String, Data> data = new TreeMap<String, Data>();
    Data all = new Data();
    int[] aliveAt;
    int[] diedAfter;

    public Churn() {
    }

    public Churn(BugCollection bugCollection) {
        this.bugCollection = bugCollection;
    }

    public void setBugCollection(BugCollection bugCollection) {
        this.bugCollection = bugCollection;
    }

    String getKey(BugInstance b) {
        return b.getType();
    }

    public Churn execute() {
        this.data.put("all", this.all);
        this.aliveAt = new int[(int)this.bugCollection.getSequenceNumber() + 1];
        this.diedAfter = new int[(int)this.bugCollection.getSequenceNumber() + 1];
        for (BugInstance bugInstance : this.bugCollection) {
            int t;
            int lifespan;
            String key = this.getKey(bugInstance);
            Data d = this.data.get(key);
            if (d == null) {
                d = new Data();
                this.data.put(key, d);
            }
            d.update(bugInstance);
            this.all.update(bugInstance);
            long first = bugInstance.getFirstVersion();
            long last = bugInstance.getLastVersion();
            if (last != -1L) {
                System.out.printf("%3d #fixed %s\n", last, key);
            }
            if (first != 0L && last != -1L) {
                lifespan = (int)(last - first + 1L);
                System.out.printf("%3d #age %s\n", lifespan, key);
                System.out.printf("%3d %3d #spread %s\n", first, last, key);
                int n = lifespan;
                this.diedAfter[n] = this.diedAfter[n] + 1;
                t = 1;
                while (t < lifespan) {
                    int n2 = t++;
                    this.aliveAt[n2] = this.aliveAt[n2] + 1;
                }
                continue;
            }
            if (first == 0L) continue;
            lifespan = (int)(this.bugCollection.getSequenceNumber() - first + 1L);
            t = 1;
            while (t < lifespan) {
                int n = t++;
                this.aliveAt[n] = this.aliveAt[n] + 1;
            }
        }
        return this;
    }

    public void dump(PrintStream out) {
        for (int t = 1; t < this.aliveAt.length; ++t) {
            if (this.aliveAt[t] == 0) continue;
            System.out.printf("%3d%% %4d %5d %3d #decay\n", this.diedAfter[t] * 100 / this.aliveAt[t], this.diedAfter[t], this.aliveAt[t], t);
        }
        System.out.printf("%7s %3s %5s %5s %5s  %s\n", "chi", "%", "const", "fix", "max", "kind");
        double fixRate = this.fixRate == -1 ? (double)this.all.fixed / (double)(this.all.fixed + this.all.persist) : (double)this.fixRate / 100.0;
        for (Map.Entry<String, Data> e : this.data.entrySet()) {
            Data d = e.getValue();
            int total = d.persist + d.fixed;
            if (total < 2) continue;
            double expectedFixed = fixRate * (double)total;
            double expectedPersist = (1.0 - fixRate) * (double)total;
            double chiValue = ((double)d.fixed - expectedFixed) * ((double)d.fixed - expectedFixed) / expectedFixed + ((double)d.persist - expectedPersist) * ((double)d.persist - expectedPersist) / expectedPersist;
            if (expectedFixed > (double)d.fixed) {
                chiValue = -chiValue;
            }
            System.out.printf("%7.1f %3d %5d %5d %5d %s\n", chiValue, d.fixed * 100 / total, d.persist, d.fixed, d.maxRemovedAtOnce(), e.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        DetectorFactoryCollection.instance();
        Churn churn = new Churn();
        ChurnCommandLine commandLine = churn.new ChurnCommandLine();
        int argCount = commandLine.parse(args, 0, 2, "Usage: " + Churn.class.getName() + " [options] [<xml results> [<history]] ");
        SortedBugCollection bugCollection = new SortedBugCollection();
        if (argCount < args.length) {
            bugCollection.readXML(args[argCount++]);
        } else {
            bugCollection.readXML(System.in);
        }
        churn.setBugCollection(bugCollection);
        churn.execute();
        PrintStream out = System.out;
        try {
            if (argCount < args.length) {
                out = new PrintStream(new FileOutputStream(args[argCount++]), true);
            }
            churn.dump(out);
        }
        finally {
            out.close();
        }
    }

    class ChurnCommandLine
    extends CommandLine {
        ChurnCommandLine() {
            this.addOption("-fixRate", "percentage", "expected fix rate for chi test");
        }

        public void handleOption(String option, String optionalExtraPart) {
            throw new IllegalArgumentException("unknown option: " + option);
        }

        public void handleOptionWithArgument(String option, String argument) {
            if (!option.equals("-fixRate")) {
                throw new IllegalArgumentException("unknown option: " + option);
            }
            Churn.this.fixRate = Integer.parseInt(argument);
        }
    }

    static class Data {
        int persist;
        int fixed;
        Map<Long, Integer> lastCount = new HashMap<Long, Integer>();

        Data() {
        }

        int maxRemovedAtOnce() {
            int count = 0;
            for (int c : this.lastCount.values()) {
                if (count >= c) continue;
                count = c;
            }
            return count;
        }

        void update(BugInstance bug) {
            if (bug.isDead()) {
                ++this.fixed;
            } else {
                ++this.persist;
            }
            long lastVersion = bug.getLastVersion();
            if (lastVersion != -1L) {
                Integer v = this.lastCount.get(lastVersion);
                if (v == null) {
                    this.lastCount.put(lastVersion, 0);
                } else {
                    this.lastCount.put(lastVersion, v + 1);
                }
            }
        }
    }
}

