/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.dialog;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.model.ui.ModelUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileFilter
extends ViewerFilter {
    private List fFilter;
    private Set<IResource> fFiles;
    private Set<String> fExtensions = new HashSet<String>();
    private boolean fConsiderExtension = true;

    public FileFilter(List objects, String[] extensions) {
        this.fFilter = objects;
        if (extensions == null || extensions.length == 0) {
            this.fConsiderExtension = false;
            this.fExtensions = null;
        } else {
            int i = 0;
            while (i < extensions.length) {
                this.fExtensions.add(extensions[i]);
                ++i;
            }
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.fFiles.contains(element) && !this.fFilter.contains(element);
    }

    private void init() {
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            public void run() {
                FileFilter.this.fFiles = new HashSet();
                FileFilter.this.collect((IContainer)ResourcesPlugin.getWorkspace().getRoot(), FileFilter.this.fFiles);
            }
        });
    }

    private boolean collect(IContainer container, Set<IResource> set) {
        if (container == null || !container.isAccessible()) {
            return false;
        }
        boolean added = false;
        try {
            IResource[] resources = container.members();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    if (this.checkFile(file)) {
                        set.add((IResource)file);
                        added = true;
                    }
                } else if (resource instanceof IContainer && this.collect((IContainer)resource, set)) {
                    set.add(resource);
                    added = true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        return added;
    }

    private boolean checkFile(IFile file) {
        String ext = file.getFileExtension();
        if (!this.fConsiderExtension || this.fExtensions == null || ext == null) {
            return false;
        }
        return this.fExtensions.contains(ext);
    }

    public void considerExtension(boolean considerExtension) {
        this.fConsiderExtension = considerExtension;
        this.init();
    }
}

