/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.action.impl;

import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.XModelMetaData;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.XAttributeDataImpl;
import org.jboss.tools.common.meta.impl.XMetaDataConstants;
import org.jboss.tools.common.meta.impl.XMetaDataLoader;
import org.jboss.tools.common.meta.impl.XModelMetaDataImpl;
import org.w3c.dom.Element;

public class XEntityDataImpl
implements XEntityData,
XMetaDataConstants {
    private String entityname;
    private XModelEntity entity = null;
    private XAttributeDataImpl[] attributes;
    private boolean mandatory;
    private boolean references = false;

    public boolean getMandatoryFlag() {
        return this.mandatory;
    }

    public XAttributeData[] getAttributeData() {
        return this.attributes;
    }

    public XModelEntity getModelEntity() {
        return this.references ? this.entity : (this.entity = this.loadReference());
    }

    private XModelEntity loadReference() {
        this.references = true;
        XModelMetaData meta = XModelMetaDataImpl.getInstance();
        return meta == null ? null : meta.getEntity(this.entityname);
    }

    public void setDefaultValues() {
        int i = 0;
        while (i < this.attributes.length) {
            this.attributes[i].setDefaultValue();
            ++i;
        }
    }

    public void load(Element el) {
        this.entityname = el.getAttribute("EntityName");
        this.mandatory = "yes".equals(el.getAttribute("Mandatory"));
        Element[] cs = XMetaDataLoader.getChildrenElements(el, "AttributeData");
        this.attributes = new XAttributeDataImpl[cs.length];
        int i = 0;
        while (i < cs.length) {
            this.attributes[i] = new XAttributeDataImpl();
            this.attributes[i].setEntityData(this);
            this.attributes[i].load(cs[i]);
            ++i;
        }
    }

    public String getEntityName() {
        return this.entityname;
    }

    public static XEntityDataImpl create(String[][] data) {
        XEntityDataImpl impl = new XEntityDataImpl();
        impl.entityname = data[0][0];
        impl.mandatory = data[0].length > 1 && "yes".equals(data[0][1]);
        impl.attributes = new XAttributeDataImpl[data.length - 1];
        int i = 0;
        while (i < impl.attributes.length) {
            impl.attributes[i] = XAttributeDataImpl.create(impl.entityname, data[i + 1][0], data[i + 1].length > 1 && "yes".equals(data[i + 1][1]));
            impl.attributes[i].setEntityData(impl);
            ++i;
        }
        return impl;
    }

    private XAttributeData find(String name) {
        int i = 0;
        while (i < this.attributes.length) {
            if (this.attributes[i].getAttribute().getName().equals(name)) {
                return this.attributes[i];
            }
            ++i;
        }
        return null;
    }

    public String getValue(String name) {
        XAttributeData d = this.find(name);
        return d == null ? null : d.getValue();
    }

    public void setValue(String name, String value) {
        XAttributeData d = this.find(name);
        if (d != null) {
            d.setValue(value);
        }
    }
}

