/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.common.meta.impl.EmptyResolver;
import org.jboss.tools.common.meta.impl.MetaResourceLoader;
import org.jboss.tools.common.meta.impl.ModuleRef;
import org.jboss.tools.common.meta.impl.Parser;
import org.jboss.tools.common.meta.impl.XMetaDataLoader;
import org.jboss.tools.common.meta.impl.XModelMetaDataImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.xml.XMLEntityResolver;
import org.jboss.tools.common.xml.XMLUtilities;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class MetaLibLoader {
    public static String DOC_PUBLICID = "-//Red Hat, Inc.//DTD Meta 1.0//EN";
    public static boolean validateMetaXML = false;
    private XModelMetaDataImpl meta = null;
    private HashSet<String> metas = new HashSet();
    private ArrayList<ModuleRef> metarefs = new ArrayList();
    private Element root = XMLUtilities.createDocumentElement((String)"meta");

    static {
        try {
            Class<MetaLibLoader> c = MetaLibLoader.class;
            XMLEntityResolver.registerPublicEntity((String)DOC_PUBLICID, c, (String)"/meta/meta.dtd");
        }
        catch (IOException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public void load(XModelMetaDataImpl meta) {
        this.meta = meta;
        Map<String, URL> resources = MetaResourceLoader.getMetaResources();
        for (String path : resources.keySet()) {
            URL url = resources.get(path);
            this.load(path, url);
        }
        int i = 0;
        while (i < this.metarefs.size()) {
            ModuleRef r = this.metarefs.get(i);
            this.load(r.element, r.name, r.info);
            ++i;
        }
    }

    void sift(Set modules) {
        boolean b = true;
        while (b) {
            b = false;
            int i = this.metarefs.size() - 1;
            while (i >= 0) {
                ModuleRef r = this.metarefs.get(i);
                if (!r.acceptable(modules)) {
                    b = true;
                    this.metarefs.remove(i);
                }
                --i;
            }
        }
    }

    void load(String name, URL url) {
        block35: {
            if (url == null) {
                return;
            }
            InputStream stream1 = null;
            InputStream stream2 = null;
            try {
                try {
                    stream1 = url.openStream();
                    stream2 = new BufferedInputStream(stream1, 16384);
                    Element g = this.parse(stream2);
                    if (g == null) {
                        ModelPlugin.getPluginLog().logError("SAX parser failed to load meta resource " + name);
                        stream1 = url.openStream();
                        stream2 = new BufferedInputStream(stream1, 16384);
                        g = XMLUtilities.getElement((InputStream)stream2, (EntityResolver)new EmptyResolver());
                    }
                    if (g == null) {
                        ModelPlugin.getPluginLog().logInfo("Corrupted meta resource " + name);
                    } else {
                        this.load0(g, name, url.toString());
                    }
                }
                catch (IOException iOException) {
                    ModelPlugin.getPluginLog().logError("MetaLoader: Cannot read resource " + url.toString());
                    if (stream2 != null) {
                        try {
                            stream2.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                if (stream2 != null) {
                    try {
                        stream2.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stream2 != null) {
                try {
                    stream2.close();
                }
                catch (IOException iOException) {}
            }
            if (validateMetaXML) {
                InputStream stream3 = null;
                try {
                    try {
                        stream3 = url.openStream();
                        InputSource is = new InputSource(stream3);
                        String[] errors = XMLUtil.getXMLErrors(is, true);
                        if (errors != null && errors.length > 0) {
                            ModelPlugin.getPluginLog().logInfo("Errors in " + name);
                            int i = 0;
                            while (i < errors.length && i < 5) {
                                ModelPlugin.getPluginLog().logInfo(errors[i]);
                                ++i;
                            }
                        }
                    }
                    catch (IOException e) {
                        ModelPlugin.getPluginLog().logError((Throwable)e);
                        if (stream3 != null) {
                            try {
                                stream3.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block35;
                    }
                }
                catch (Throwable throwable) {
                    if (stream3 != null) {
                        try {
                            stream3.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (stream3 != null) {
                    try {
                        stream3.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    Element parse(InputStream stream) {
        Parser p = new Parser();
        p.documentElement = this.root;
        p.current = this.root;
        p.parse(stream);
        Element g = p.documentElement;
        g = XMLUtilities.getUniqueChild((Element)g, (String)"XModelEntityGroup");
        if (g != null) {
            p.documentElement.removeChild(g);
        }
        return g;
    }

    void load0(Element g, String name, String source) {
        this.metarefs.add(new ModuleRef(g, name, source));
    }

    void load(Element g, String name, String source) {
        source = source.substring(0, source.length() - name.length());
        if (!this.metas.contains(name) && g != null) {
            XMetaDataLoader.loadEntityGroup(this.meta, g);
            this.metas.add(name);
            this.meta.getLoadedModules().put(name, source);
        }
    }
}

