/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.editors;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;
import org.eclipse.wst.xml.ui.internal.contentassist.NoRegionContentAssistProcessor;
import org.hibernate.eclipse.mapper.editors.HBMXMLContentAssistProcessor;
import org.hibernate.eclipse.mapper.editors.HBMXMLHyperlinkDetector;

public class HBMXMLStructuredTextViewerConfiguration
extends StructuredTextViewerConfigurationXML {
    static Map partitionToContentAssist = new HashMap();

    static {
        IContentAssistProcessor[] contentAssistProcessor = new IContentAssistProcessor[]{new HBMXMLContentAssistProcessor()};
        partitionToContentAssist.put("org.eclipse.wst.sse.ST_DEFAULT", contentAssistProcessor);
        partitionToContentAssist.put("org.eclipse.wst.xml.XML_DEFAULT", contentAssistProcessor);
        contentAssistProcessor = new IContentAssistProcessor[]{new NoRegionContentAssistProcessor()};
        partitionToContentAssist.put("org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE", contentAssistProcessor);
    }

    protected IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        return (IContentAssistProcessor[])partitionToContentAssist.get(partitionType);
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null || this.hyperLinksEnabled()) {
            return null;
        }
        IHyperlinkDetector[] baseDetectors = super.getHyperlinkDetectors(sourceViewer);
        HBMXMLHyperlinkDetector hyperlinkDetector = new HBMXMLHyperlinkDetector();
        if (baseDetectors == null || baseDetectors.length == 0) {
            return new IHyperlinkDetector[]{hyperlinkDetector};
        }
        IHyperlinkDetector[] result = new IHyperlinkDetector[baseDetectors.length + 1];
        result[0] = hyperlinkDetector;
        int i = 0;
        while (i < baseDetectors.length) {
            result[i + 1] = baseDetectors[i];
            ++i;
        }
        return result;
    }

    private boolean hyperLinksEnabled() {
        return !this.fPreferenceStore.getBoolean("hyperlinksEnabled");
    }
}

