/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.templates;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.contentassist.AbstractControlContentAssistSubjectAdapter;
import org.eclipse.jface.contentassist.ComboContentAssistSubjectAdapter;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.contentassist.TextContentAssistSubjectAdapter;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class ContentAssistHandler2 {
    private Control control;
    private AbstractControlContentAssistSubjectAdapter adapter;
    private IContentAssistant assistant;
    private FocusListener focusListener;
    private ModifyListener modifyListener;
    private IHandlerActivation activation;
    private ILabelProvider cueLabel;

    public static ContentAssistHandler2 createHandlerForCombo(Combo combo, SubjectControlContentAssistant contentAssistant) {
        return new ContentAssistHandler2((Control)combo, (AbstractControlContentAssistSubjectAdapter)new ComboContentAssistSubjectAdapter(combo), contentAssistant, null);
    }

    public static ContentAssistHandler2 createHandlerForText(Text text, SubjectControlContentAssistant contentAssistant, ILabelProvider cueLabel) {
        ContentAssistHandler2 cah = new ContentAssistHandler2((Control)text, (AbstractControlContentAssistSubjectAdapter)new TextContentAssistSubjectAdapter(text), contentAssistant, cueLabel);
        return cah;
    }

    private ContentAssistHandler2(Control control, AbstractControlContentAssistSubjectAdapter subjectAdapter, SubjectControlContentAssistant contentAssistant, ILabelProvider cueLabel) {
        this.control = control;
        this.assistant = contentAssistant;
        this.adapter = subjectAdapter;
        this.cueLabel = cueLabel;
        this.setEnabled(true);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ContentAssistHandler2.this.setEnabled(false);
            }
        });
    }

    public boolean isEnabled() {
        return this.focusListener != null;
    }

    public void setEnabled(boolean enable) {
        if (enable == this.isEnabled()) {
            return;
        }
        if (enable) {
            this.enable();
        } else {
            this.disable();
        }
    }

    private void enable() {
        if (!this.control.isDisposed()) {
            if (this.assistant instanceof SubjectControlContentAssistant) {
                ((SubjectControlContentAssistant)this.assistant).install((IContentAssistSubjectControl)this.adapter);
            }
            this.installCueLabelProvider();
            this.installFocusListener();
            if (this.control.isFocusControl()) {
                this.activate();
            }
        }
    }

    private void disable() {
        if (!this.control.isDisposed()) {
            this.assistant.uninstall();
            this.adapter.setContentAssistCueProvider(null);
            this.control.removeFocusListener(this.focusListener);
            this.focusListener = null;
            if (this.activation != null) {
                this.deactivate();
            }
        }
    }

    private void installCueLabelProvider() {
        this.adapter.setContentAssistCueProvider(this.cueLabel);
    }

    private void installFocusListener() {
        this.focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (ContentAssistHandler2.this.control instanceof Text && !ContentAssistHandler2.this.control.isDisposed()) {
                    ((Text)ContentAssistHandler2.this.control).addModifyListener(ContentAssistHandler2.this.getModifyListener());
                }
                ContentAssistHandler2.this.activate();
            }

            public void focusLost(FocusEvent e) {
                if (ContentAssistHandler2.this.activation != null && ContentAssistHandler2.this.control instanceof Text && ContentAssistHandler2.this.modifyListener != null && !ContentAssistHandler2.this.control.isDisposed()) {
                    ((Text)ContentAssistHandler2.this.control).removeModifyListener(ContentAssistHandler2.this.modifyListener);
                }
                ContentAssistHandler2.this.deactivate();
            }
        };
        this.control.addFocusListener(this.focusListener);
    }

    ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListenerImpl();
        }
        return this.modifyListener;
    }

    private void activate() {
        IHandlerService hs = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
        if (hs == null) {
            return;
        }
        this.activation = hs.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler)new H());
    }

    private void deactivate() {
        IHandlerService hs = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
        if (hs != null) {
            hs.deactivateHandler(this.activation);
        }
        this.activation = null;
    }

    class H
    extends AbstractHandler {
        H() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            if (ContentAssistHandler2.this.isEnabled()) {
                ContentAssistHandler2.this.assistant.showPossibleCompletions();
            }
            return null;
        }
    }

    class ModifyListenerImpl
    implements ModifyListener {
        ModifyListenerImpl() {
        }

        public void modifyText(ModifyEvent e) {
            if (ContentAssistHandler2.this.control == null || ContentAssistHandler2.this.control.isDisposed()) {
                return;
            }
            if (ContentAssistHandler2.this.control.isFocusControl()) {
                Composite c = ContentAssistHandler2.this.control.getParent();
                while (c != null) {
                    c.redraw();
                    if (c instanceof Shell) break;
                    c = c.getParent();
                }
            }
        }
    }
}

