/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editors.multipage;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.jboss.tools.common.editor.ObjectMultiPageEditor;
import org.jboss.tools.common.editor.ObjectTextEditor;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.texteditors.XMLTextEditorComponent;

public class DefaultMultipageEditor
extends ObjectMultiPageEditor {
    protected XMLTextEditorComponent createTextEditorComponent() {
        return new XMLTextEditorComponent();
    }

    protected void doCreatePages() {
        this.createTreePage();
        this.createTextPage();
        this.initEditors();
    }

    protected ObjectTextEditor createTextEditor() {
        return this.createTextEditorComponent();
    }

    public boolean isDirty() {
        XModelObject o = this.getModelObject();
        return o != null && o.isModified() || this.textEditor != null && this.textEditor.isModified();
    }

    protected void setNormalMode() {
        if (this.treeFormPage != null) {
            this.treeFormPage.initialize(this.getModelObject());
            this.treeFormPage.setErrorMode(this.isErrorMode());
        }
        if (this.selectionProvider != null) {
            this.updateSelectionProvider();
        }
        if (this.treeEditor != null) {
            this.treeEditor.setObject(this.object, this.isErrorMode());
        }
    }

    protected void setErrorMode() {
        if (this.treeFormPage != null) {
            this.treeFormPage.initialize(this.getModelObject());
            this.treeFormPage.setErrorMode(this.isErrorMode());
        }
        if (this.treeEditor != null) {
            this.treeEditor.setObject(this.object, this.isErrorMode());
        }
    }

    protected void checkErrorMode() {
        if (this.object == null) {
            return;
        }
        boolean i = "yes".equals(this.object.get("isIncorrect"));
        if (this.isErrorMode == i) {
            return;
        }
        this.isErrorMode = i;
    }

    public void activateErrorTab() {
        if (this.getPageCount() > 1) {
            this.setActivePage(1);
        }
    }

    protected void updateSelectionProvider() {
        int index;
        if (this.textEditor != null) {
            this.selectionProvider.addHost("textEditor", this.getTextSelectionProvider());
        }
        if (this.treeFormPage != null) {
            this.selectionProvider.addHost("treeEditor", this.treeFormPage.getSelectionProvider());
        }
        if ((index = this.getActivePage()) == this.getSourcePageIndex()) {
            if (this.textEditor != null) {
                this.selectionProvider.setHost(this.getTextSelectionProvider());
            }
            return;
        }
        if (this.treeFormPage != null) {
            this.selectionProvider.setHost(this.treeFormPage.getSelectionProvider());
        }
    }

    protected void synchronizeSelectionWithText() {
        if (this.getTextSelectionProvider() == null || this.treeFormPage == null) {
            return;
        }
        ISelection s = this.getTextSelectionProvider().getSelection();
        if (s == null || s.isEmpty() || !(s instanceof IStructuredSelection)) {
            return;
        }
        Object o = ((IStructuredSelection)s).getFirstElement();
        if (!(o instanceof XModelObject) || o == this.getModelObject()) {
            return;
        }
        this.treeFormPage.getSelectionProvider().setSelection(s);
    }
}

